"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAndFilterBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../integrations/sections/epm/screens/detail/hooks");
var _components = require("../../../../components");
var _constants = require("../../../../constants");
var _hooks2 = require("../../../../hooks");
var _bulk_actions = require("./bulk_actions");
var _agent_activity_button = require("./agent_activity_button");
var _agent_status_filter = require("./agent_status_filter");
var _dashboards_buttons = require("./dashboards_buttons");
var _agent_policy_filter = require("./filter_bar/agent_policy_filter");
var _tags_filter = require("./filter_bar/tags_filter");
var _agent_activity_badge = require("./agent_activity_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchAndFilterBar = ({
  agentPolicies,
  draftKuery,
  onDraftKueryChange,
  onSubmitSearch,
  selectedAgentPolicies,
  onSelectedAgentPoliciesChange,
  selectedStatus,
  onSelectedStatusChange,
  showUpgradeable,
  onShowUpgradeableChange,
  tags,
  selectedTags,
  onSelectedTagsChange,
  nAgentsInTable,
  totalInactiveAgents,
  totalManagedAgentIds,
  selectionMode,
  currentQuery,
  selectedAgents,
  refreshAgents,
  onClickAddAgent,
  onClickAddFleetServer,
  agentsOnCurrentPage,
  onClickAgentActivity,
  showAgentActivityTour,
  latestAgentActionErrors,
  sortField,
  sortOrder
}) => {
  const authz = (0, _hooks2.useAuthz)();
  const {
    isFirstTimeAgentUser,
    isLoading: isFirstTimeAgentUserLoading
  } = (0, _hooks.useIsFirstTimeAgentUserQuery)();
  const {
    cloud
  } = (0, _hooks2.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !isFirstTimeAgentUserLoading && !isFirstTimeAgentUser && /*#__PURE__*/_react.default.createElement(_dashboards_buttons.DashboardsButtons, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_agent_activity_badge.AgentActivityBadge, {
    recentErrors: latestAgentActionErrors,
    onClick: onClickAgentActivity
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_agent_activity_button.AgentActivityButton, {
    onClickAgentActivity: onClickAgentActivity,
    showAgentActivityTour: showAgentActivityTour
  })), authz.fleet.addFleetServers && !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addFleetServerButton.tooltip",
      defaultMessage: "Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClickAddFleetServer,
    "data-test-subj": "addFleetServerButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.addFleetServerButton",
    defaultMessage: "Add Fleet Server"
  })))) : null, authz.fleet.addAgents ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addAgentButton.tooltip",
      defaultMessage: "Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onClickAddAgent,
    "data-test-subj": "addAgentButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.addButton",
    defaultMessage: "Add agent"
  })))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_components.SearchBar, {
    value: draftKuery,
    fieldPrefix: _constants.AGENTS_PREFIX,
    indexPattern: _constants.AGENTS_INDEX,
    onChange: (newSearch, submit) => {
      onDraftKueryChange(newSearch);
      if (submit) {
        onSubmitSearch(newSearch);
      }
    },
    dataTestSubj: "agentList.queryInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_agent_status_filter.AgentStatusFilter, {
    selectedStatus: selectedStatus,
    onSelectedStatusChange: onSelectedStatusChange,
    totalInactiveAgents: totalInactiveAgents,
    disabled: agentPolicies.length === 0
  }), /*#__PURE__*/_react.default.createElement(_tags_filter.TagsFilter, {
    tags: tags,
    selectedTags: selectedTags,
    onSelectedTagsChange: onSelectedTagsChange
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_filter.AgentPolicyFilter, {
    selectedAgentPolicies: selectedAgentPolicies,
    onSelectedAgentPoliciesChange: onSelectedAgentPoliciesChange,
    agentPolicies: agentPolicies
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: showUpgradeable,
    onClick: () => {
      onShowUpgradeableChange(!showUpgradeable);
    },
    "data-test-subj": "agentList.showUpgradeable"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.showUpgradeableFilterLabel",
    defaultMessage: "Upgrade available"
  })))), selectionMode === 'manual' && selectedAgents.length || selectionMode === 'query' && nAgentsInTable > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_bulk_actions.AgentBulkActions, {
    nAgentsInTable: nAgentsInTable,
    totalManagedAgentIds: totalManagedAgentIds,
    selectionMode: selectionMode,
    currentQuery: currentQuery,
    selectedAgents: selectedAgents,
    agentsOnCurrentPage: agentsOnCurrentPage,
    refreshAgents: refreshAgents,
    allTags: tags,
    agentPolicies: agentPolicies,
    sortField: sortField,
    sortOrder: sortOrder
  })) : null))));
};
exports.SearchAndFilterBar = SearchAndFilterBar;