"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBulkActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../components");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../../common/constants");
var _utils = require("../utils");
var _agent_request_diagnostics_modal = require("../../components/agent_request_diagnostics_modal");
var _export_csv = require("../hooks/export_csv");
var _agent_export_csv_modal = require("../../components/agent_export_csv_modal");
var _tags_add_remove = require("./tags_add_remove");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentBulkActions = ({
  nAgentsInTable,
  totalManagedAgentIds,
  selectionMode,
  currentQuery,
  selectedAgents,
  agentsOnCurrentPage,
  refreshAgents,
  allTags,
  agentPolicies,
  sortField,
  sortOrder
}) => {
  const licenseService = (0, _hooks.useLicense)();
  const authz = (0, _hooks.useAuthz)();
  const isLicenceAllowingScheduleUpgrade = licenseService.hasAtLeast(_constants.LICENSE_FOR_SCHEDULE_UPGRADE);

  // Bulk actions menu states
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const closeMenu = () => setIsMenuOpen(false);
  const onClickMenu = () => setIsMenuOpen(!isMenuOpen);

  // Actions states
  const [isReassignFlyoutOpen, setIsReassignFlyoutOpen] = (0, _react.useState)(false);
  const [isUnenrollModalOpen, setIsUnenrollModalOpen] = (0, _react.useState)(false);
  const [upgradeModalState, setUpgradeModalState] = (0, _react.useState)({
    isOpen: false,
    isScheduled: false,
    isUpdating: false
  });
  const [isTagAddVisible, setIsTagAddVisible] = (0, _react.useState)(false);
  const [isRequestDiagnosticsModalOpen, setIsRequestDiagnosticsModalOpen] = (0, _react.useState)(false);
  const [isExportCSVModalOpen, setIsExportCSVModalOpen] = (0, _react.useState)(false);

  // update the query removing the "managed" agents in any state (unenrolled, offline, etc)
  const selectionQuery = (0, _react.useMemo)(() => {
    if (totalManagedAgentIds.length) {
      const excludedKuery = `${_constants.AGENTS_PREFIX}.agent.id : (${totalManagedAgentIds.map(id => `"${id}"`).join(' or ')})`;
      return `(${currentQuery}) AND NOT (${excludedKuery})`;
    } else {
      return currentQuery;
    }
  }, [currentQuery, totalManagedAgentIds]);
  const agents = selectionMode === 'manual' ? selectedAgents : selectionQuery;
  const agentCount = selectionMode === 'manual' ? selectedAgents.length : nAgentsInTable - (totalManagedAgentIds === null || totalManagedAgentIds === void 0 ? void 0 : totalManagedAgentIds.length);
  const [tagsPopoverButton, setTagsPopoverButton] = (0, _react.useState)();
  const {
    generateReportingJobCSV
  } = (0, _export_csv.useExportCSV)();
  const menuItems = [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.addRemoveTags",
      "data-test-subj": "agentBulkActionsAddRemoveTags",
      defaultMessage: "Add / remove tags"
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "tag",
      size: "m"
    }),
    disabled: !authz.fleet.allAgents,
    onClick: event => {
      setTagsPopoverButton(event.target.closest('button'));
      setIsTagAddVisible(!isTagAddVisible);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.reassignPolicy",
      "data-test-subj": "agentBulkActionsReassign",
      defaultMessage: "Assign to new policy"
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pencil",
      size: "m"
    }),
    disabled: !authz.fleet.allAgents,
    onClick: () => {
      closeMenu();
      setIsReassignFlyoutOpen(true);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.upgradeAgents",
      "data-test-subj": "agentBulkActionsUpgrade",
      defaultMessage: "Upgrade {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "refresh",
      size: "m"
    }),
    disabled: !authz.fleet.allAgents,
    onClick: () => {
      closeMenu();
      setUpgradeModalState({
        isOpen: true,
        isScheduled: false,
        isUpdating: false
      });
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.scheduleUpgradeAgents",
      "data-test-subj": "agentBulkActionsScheduleUpgrade",
      defaultMessage: "Schedule upgrade for {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "timeRefresh",
      size: "m"
    }),
    disabled: !authz.fleet.allAgents || !isLicenceAllowingScheduleUpgrade,
    onClick: () => {
      closeMenu();
      setUpgradeModalState({
        isOpen: true,
        isScheduled: true,
        isUpdating: false
      });
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.restartUpgradeAgents",
      "data-test-subj": "agentBulkActionsRestartUpgrade",
      defaultMessage: "Restart upgrade {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "refresh",
      size: "m"
    }),
    disabled: !authz.fleet.allAgents,
    onClick: () => {
      closeMenu();
      setUpgradeModalState({
        isOpen: true,
        isScheduled: false,
        isUpdating: true
      });
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.requestDiagnostics",
      "data-test-subj": "agentBulkActionsRequestDiagnostics",
      defaultMessage: "Request diagnostics for {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      }
    }),
    disabled: !authz.fleet.readAgents,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "download",
      size: "m"
    }),
    onClick: () => {
      closeMenu();
      setIsRequestDiagnosticsModalOpen(true);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.unenrollAgents",
      "data-test-subj": "agentBulkActionsUnenroll",
      defaultMessage: "Unenroll {agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      }
    }),
    disabled: !authz.fleet.allAgents,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash",
      size: "m"
    }),
    onClick: () => {
      closeMenu();
      setIsUnenrollModalOpen(true);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.exportAgents",
      "data-test-subj": "bulkAgentExportBtn",
      defaultMessage: "Export {agentCount, plural, one {# agent} other {# agents}} as CSV",
      values: {
        agentCount
      }
    }),
    disabled: !authz.fleet.readAgents,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "exportAction",
      size: "m"
    }),
    onClick: () => {
      closeMenu();
      setIsExportCSVModalOpen(true);
    }
  }];
  const panels = [{
    id: 0,
    items: menuItems
  }];
  const getSelectedTagsFromAgents = (0, _react.useMemo)(() => (0, _utils.getCommonTags)(agents, agentsOnCurrentPage !== null && agentsOnCurrentPage !== void 0 ? agentsOnCurrentPage : [], agentPolicies), [agents, agentsOnCurrentPage, agentPolicies]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isReassignFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentReassignAgentPolicyModal, {
    agents: agents,
    onClose: () => {
      setIsReassignFlyoutOpen(false);
      refreshAgents();
    }
  })), isUnenrollModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentUnenrollAgentModal, {
    agents: agents,
    agentCount: agentCount,
    onClose: () => {
      setIsUnenrollModalOpen(false);
      refreshAgents({
        refreshTags: true
      });
    }
  })), isExportCSVModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_export_csv_modal.AgentExportCSVModal, {
    onSubmit: columns => {
      generateReportingJobCSV(agents, columns, {
        field: sortField,
        direction: sortOrder
      });
      setIsExportCSVModalOpen(false);
    },
    onClose: () => {
      setIsExportCSVModalOpen(false);
    },
    agentCount: agentCount
  })), upgradeModalState.isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentUpgradeAgentModal, {
    agents: agents,
    agentCount: agentCount,
    isScheduled: upgradeModalState.isScheduled,
    isUpdating: upgradeModalState.isUpdating,
    onClose: () => {
      setUpgradeModalState({
        isOpen: false,
        isScheduled: false,
        isUpdating: false
      });
      refreshAgents();
    }
  })), isTagAddVisible && /*#__PURE__*/_react.default.createElement(_tags_add_remove.TagsAddRemove, {
    agents: Array.isArray(agents) ? agents.map(agent => agent.id) : agents,
    allTags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: getSelectedTagsFromAgents,
    button: tagsPopoverButton,
    onTagsUpdated: () => {
      refreshAgents({
        refreshTags: true
      });
    },
    onClosePopover: () => {
      setIsTagAddVisible(false);
      closeMenu();
    }
  }), isRequestDiagnosticsModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: agents,
    agentCount: agentCount,
    onClose: () => {
      setIsRequestDiagnosticsModalOpen(false);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "agentBulkActionsMenu",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onClickMenu,
      "data-test-subj": "agentBulkActionsButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentBulkActions.actions",
      defaultMessage: "Actions"
    })),
    isOpen: isMenuOpen,
    closePopover: closeMenu,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  })))));
};
exports.AgentBulkActions = AgentBulkActions;