"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeInProgressActivityItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
var _helpers = require("./helpers");
var _view_agents_button = require("./view_agents_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpgradeInProgressActivityItem = ({
  action,
  abortUpgrade,
  onClickViewAgents
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const theme = (0, _eui.useEuiTheme)();
  const [isAborting, setIsAborting] = (0, _react.useState)(false);
  const onClickAbortUpgrade = (0, _react.useCallback)(async () => {
    try {
      setIsAborting(true);
      await abortUpgrade(action);
    } finally {
      setIsAborting(false);
    }
  }, [action, abortUpgrade]);
  const isScheduled = (0, _react.useMemo)(() => {
    if (!action.startTime) {
      return false;
    }
    const now = Date.now();
    const startDate = new Date(action.startTime).getTime();
    return startDate > now;
  }, [action]);
  const showCancelButton = (0, _react.useMemo)(() => {
    return isScheduled || action.hasRolloutPeriod;
  }, [action, isScheduled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isScheduled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "clock"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: theme.euiTheme.colors.textPrimary,
    "data-test-subj": "upgradeInProgressTitle"
  }, isScheduled && action.startTime ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.scheduleTitle",
    defaultMessage: "{nbAgents} agents scheduled to upgrade to version {version}",
    values: {
      nbAgents: action.nbAgentsActioned - action.nbAgentsAck,
      version: action.version
    }
  }) : (0, _helpers.inProgressTitle)(action))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "upgradeInProgressDescription"
  }, /*#__PURE__*/_react.default.createElement("p", null, isScheduled && action.startTime ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.scheduledDescription",
    defaultMessage: "Scheduled for "
  }), /*#__PURE__*/_react.default.createElement("strong", null, (0, _helpers.formattedTime)(action.startTime)), ".\xA0") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _helpers.inProgressDescription)(action.creationTime), "\xA0"), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.upgradeDescription",
    defaultMessage: "{guideLink} about agent upgrades.",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.guideLink",
        defaultMessage: "Learn more"
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_agents_button.ViewAgentsButton, {
    action: action,
    onClickViewAgents: onClickViewAgents
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showCancelButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onClickAbortUpgrade,
    isLoading: isAborting,
    "data-test-subj": "abortBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.abortUpgradeButtom",
    defaultMessage: "Cancel"
  })) : null)))));
};
exports.UpgradeInProgressActivityItem = UpgradeInProgressActivityItem;