"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentless = void 0;
exports.useSetupTechnology = useSetupTechnology;
var _react = require("react");
var _hooks = require("../../../../../hooks");
var _generate_new_agent_policy = require("../../../../../../../../common/services/generate_new_agent_policy");
var _types = require("../../../../../types");
var _components = require("../../components");
var _constants = require("../../../../../../../../common/constants");
var _agentless_policy_helper = require("../../../../../../../../common/services/agentless_policy_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentless = () => {
  var _config$agentless;
  const config = (0, _hooks.useConfig)();
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const isServerless = !!(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const isCloud = !!(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled);
  const isAgentlessEnabled = (isCloud || isServerless) && ((_config$agentless = config.agentless) === null || _config$agentless === void 0 ? void 0 : _config$agentless.enabled) === true;
  const isAgentlessAgentPolicy = agentPolicy => {
    if (!agentPolicy) return false;
    return isAgentlessEnabled && !!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless);
  };

  // When an integration has at least a policy template enabled for agentless
  const isAgentlessIntegration = packageInfo => {
    if (isAgentlessEnabled && (0, _agentless_policy_helper.isAgentlessIntegration)(packageInfo)) {
      return true;
    }
    return false;
  };
  return {
    isAgentlessEnabled,
    isAgentlessAgentPolicy,
    isAgentlessIntegration
  };
};
exports.useAgentless = useAgentless;
function useSetupTechnology({
  setNewAgentPolicy,
  newAgentPolicy,
  updatePackagePolicy,
  setSelectedPolicyTab,
  packageInfo,
  packagePolicy,
  isEditPage,
  agentPolicies,
  integrationToEnable
}) {
  const {
    isAgentlessEnabled
  } = useAgentless();

  // this is a placeholder for the new agent-BASED policy that will be used when the user switches from agentless to agent-based and back
  const orginalAgentPolicyRef = (0, _react.useRef)({
    ...newAgentPolicy
  });
  const [currentAgentPolicy, setCurrentAgentPolicy] = (0, _react.useState)(newAgentPolicy);
  const allowedSetupTechnologies = (0, _react.useMemo)(() => {
    return (0, _agentless_policy_helper.isOnlyAgentlessIntegration)(packageInfo, integrationToEnable) ? [_types.SetupTechnology.AGENTLESS] : [_types.SetupTechnology.AGENTLESS, _types.SetupTechnology.AGENT_BASED];
  }, [integrationToEnable, packageInfo]);
  const [selectedSetupTechnology, setSelectedSetupTechnology] = (0, _react.useState)(_types.SetupTechnology.AGENT_BASED);
  // derive default setup technology based on package info and selected integration
  const [defaultSetupTechnology, setDefaultSetupTechnology] = (0, _react.useState)(_types.SetupTechnology.AGENT_BASED);
  (0, _react.useEffect)(() => {
    const shouldBeDefault = isAgentlessEnabled && ((0, _agentless_policy_helper.isOnlyAgentlessIntegration)(packageInfo, integrationToEnable) || isAgentlessSetupDefault(packageInfo, integrationToEnable)) ? _types.SetupTechnology.AGENTLESS : _types.SetupTechnology.AGENT_BASED;
    setDefaultSetupTechnology(shouldBeDefault);
    setSelectedSetupTechnology(shouldBeDefault);
  }, [isAgentlessEnabled, packageInfo, integrationToEnable]);
  const agentlessPolicyName = (0, _agentless_policy_helper.getAgentlessAgentPolicyNameFromPackagePolicyName)(packagePolicy.name);
  const handleSetupTechnologyChange = (0, _react.useCallback)(setupTechnology => {
    if (!isAgentlessEnabled || setupTechnology === selectedSetupTechnology) {
      return;
    }
    setSelectedPolicyTab(_components.SelectedPolicyTab.NEW);
    setSelectedSetupTechnology(setupTechnology);
  }, [isAgentlessEnabled, selectedSetupTechnology, setSelectedPolicyTab, setSelectedSetupTechnology]);
  if (isEditPage && agentPolicies && agentPolicies.some(policy => policy.supports_agentless) && selectedSetupTechnology === _types.SetupTechnology.AGENT_BASED) {
    setSelectedSetupTechnology(_types.SetupTechnology.AGENTLESS);
  }
  if (!isEditPage && packagePolicy && isAgentlessEnabled && selectedSetupTechnology === _types.SetupTechnology.AGENTLESS && (!currentAgentPolicy.supports_agentless || agentlessPolicyName !== currentAgentPolicy.name)) {
    const nextNewAgentlessPolicy = {
      ...(0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
        inactivity_timeout: _constants.AGENTLESS_AGENT_POLICY_INACTIVITY_TIMEOUT,
        supports_agentless: true,
        monitoring_enabled: _constants.AGENTLESS_AGENT_POLICY_MONITORING
      }),
      name: agentlessPolicyName,
      global_data_tags: getGlobaDataTags(packageInfo)
    };
    const agentlessPolicy = getAgentlessPolicy(packageInfo);
    if (agentlessPolicy) {
      nextNewAgentlessPolicy.agentless = agentlessPolicy;
    }
    setCurrentAgentPolicy(nextNewAgentlessPolicy);
    setNewAgentPolicy(nextNewAgentlessPolicy);
    updatePackagePolicy({
      supports_agentless: true
    });
  }
  if (!isEditPage && selectedSetupTechnology === _types.SetupTechnology.AGENT_BASED && (currentAgentPolicy.supports_agentless || packagePolicy.supports_agentless)) {
    const nextNewAgentlessPolicy = {
      ...orginalAgentPolicyRef.current,
      supports_agentless: false
    };
    setCurrentAgentPolicy(nextNewAgentlessPolicy);
    setNewAgentPolicy(nextNewAgentlessPolicy);
    updatePackagePolicy({
      supports_agentless: false
    });
  }
  return {
    handleSetupTechnologyChange,
    allowedSetupTechnologies,
    selectedSetupTechnology,
    defaultSetupTechnology
  };
}
const isAgentlessSetupDefault = (packageInfo, integrationToEnable) => {
  var _packageInfo$policy_t, _packageInfo$policy_t2, _packageInfo$policy_t3, _packageInfo$policy_t4;
  if (packageInfo && packageInfo.policy_templates && packageInfo.policy_templates.length > 0 && (integrationToEnable && packageInfo !== null && packageInfo !== void 0 && (_packageInfo$policy_t = packageInfo.policy_templates) !== null && _packageInfo$policy_t !== void 0 && (_packageInfo$policy_t2 = _packageInfo$policy_t.find(p => p.name === integrationToEnable)) !== null && _packageInfo$policy_t2 !== void 0 && (_packageInfo$policy_t3 = _packageInfo$policy_t2.deployment_modes) !== null && _packageInfo$policy_t3 !== void 0 && _packageInfo$policy_t3.agentless.is_default || packageInfo !== null && packageInfo !== void 0 && (_packageInfo$policy_t4 = packageInfo.policy_templates) !== null && _packageInfo$policy_t4 !== void 0 && _packageInfo$policy_t4.every(p => {
    var _p$deployment_modes;
    return (_p$deployment_modes = p.deployment_modes) === null || _p$deployment_modes === void 0 ? void 0 : _p$deployment_modes.agentless.is_default;
  }))) {
    return true;
  }
  return false;
};
const getGlobaDataTags = packageInfo => {
  var _packageInfo$policy_t5, _agentlessPolicyTempl;
  if (!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates) && !(packageInfo !== null && packageInfo !== void 0 && (_packageInfo$policy_t5 = packageInfo.policy_templates) !== null && _packageInfo$policy_t5 !== void 0 && _packageInfo$policy_t5.some(policy => policy.deployment_modes))) {
    return undefined;
  }
  const agentlessPolicyTemplate = packageInfo.policy_templates.find(policy => policy.deployment_modes);

  // assumes that all the policy templates agentless deployments modes indentify have the same organization, division and team
  const agentlessInfo = agentlessPolicyTemplate === null || agentlessPolicyTemplate === void 0 ? void 0 : (_agentlessPolicyTempl = agentlessPolicyTemplate.deployment_modes) === null || _agentlessPolicyTempl === void 0 ? void 0 : _agentlessPolicyTempl.agentless;
  if (agentlessInfo === undefined || !agentlessInfo.organization || !agentlessInfo.division || !agentlessInfo.team) {
    return undefined;
  }
  return [{
    name: _constants.AGENTLESS_GLOBAL_TAG_NAME_ORGANIZATION,
    value: agentlessInfo.organization
  }, {
    name: _constants.AGENTLESS_GLOBAL_TAG_NAME_DIVISION,
    value: agentlessInfo.division
  }, {
    name: _constants.AGENTLESS_GLOBAL_TAG_NAME_TEAM,
    value: agentlessInfo.team
  }];
};
const getAgentlessPolicy = packageInfo => {
  var _packageInfo$policy_t6, _agentlessPolicyTempl2;
  if (!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates) && !(packageInfo !== null && packageInfo !== void 0 && (_packageInfo$policy_t6 = packageInfo.policy_templates) !== null && _packageInfo$policy_t6 !== void 0 && _packageInfo$policy_t6.some(policy => policy.deployment_modes))) {
    return;
  }
  const agentlessPolicyTemplate = packageInfo.policy_templates.find(policy => policy.deployment_modes);

  // assumes that all the policy templates agentless deployments modes indentify have the same organization, division and team
  const agentlessInfo = agentlessPolicyTemplate === null || agentlessPolicyTemplate === void 0 ? void 0 : (_agentlessPolicyTempl2 = agentlessPolicyTemplate.deployment_modes) === null || _agentlessPolicyTempl2 === void 0 ? void 0 : _agentlessPolicyTempl2.agentless;
  if (!(agentlessInfo !== null && agentlessInfo !== void 0 && agentlessInfo.resources)) {
    return;
  }
  return {
    resources: agentlessInfo.resources
  };
};