"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentlessAgentPolicyNameFromPackagePolicyName = void 0;
exports.inputNotAllowedInAgentless = inputNotAllowedInAgentless;
exports.isOnlyAgentlessPolicyTemplate = exports.isOnlyAgentlessIntegration = exports.isAgentlessIntegration = void 0;
exports.validateAgentlessInputs = validateAgentlessInputs;
var _constants = require("../constants");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAgentlessIntegration = packageInfo => {
  if (packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates && (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates.length) > 0 && !!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates.find(policyTemplate => {
    var _policyTemplate$deplo;
    return (policyTemplate === null || policyTemplate === void 0 ? void 0 : (_policyTemplate$deplo = policyTemplate.deployment_modes) === null || _policyTemplate$deplo === void 0 ? void 0 : _policyTemplate$deplo.agentless.enabled) === true;
  }))) {
    return true;
  }
  return false;
};
exports.isAgentlessIntegration = isAgentlessIntegration;
const getAgentlessAgentPolicyNameFromPackagePolicyName = packagePolicyName => {
  return `Agentless policy for ${packagePolicyName}`;
};
exports.getAgentlessAgentPolicyNameFromPackagePolicyName = getAgentlessAgentPolicyNameFromPackagePolicyName;
const isOnlyAgentlessIntegration = (packageInfo, integrationToEnable) => {
  var _packageInfo$policy_t, _packageInfo$policy_t2, _packageInfo$policy_t3;
  if (packageInfo && packageInfo.policy_templates && ((_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.length) > 0 && (integrationToEnable && (_packageInfo$policy_t2 = packageInfo.policy_templates) !== null && _packageInfo$policy_t2 !== void 0 && _packageInfo$policy_t2.find(p => p.name === integrationToEnable && isOnlyAgentlessPolicyTemplate(p)) || (_packageInfo$policy_t3 = packageInfo.policy_templates) !== null && _packageInfo$policy_t3 !== void 0 && _packageInfo$policy_t3.every(p => isOnlyAgentlessPolicyTemplate(p)))) {
    return true;
  }
  return false;
};
exports.isOnlyAgentlessIntegration = isOnlyAgentlessIntegration;
const isOnlyAgentlessPolicyTemplate = policyTemplate => {
  return Boolean(policyTemplate.deployment_modes && policyTemplate.deployment_modes.agentless.enabled === true && (!policyTemplate.deployment_modes.default || policyTemplate.deployment_modes.default.enabled === false));
};

/*
 * Check if the package policy inputs is not allowed in agentless
 */
exports.isOnlyAgentlessPolicyTemplate = isOnlyAgentlessPolicyTemplate;
function inputNotAllowedInAgentless(inputType, supportsAgentless) {
  return supportsAgentless === true && _constants.AGENTLESS_DISABLED_INPUTS.includes(inputType);
}

/*
 * Throw error if trying to enabling an input that is not allowed in agentless
 */
function validateAgentlessInputs(packagePolicyInputs, supportsAgentless) {
  if (Array.isArray(packagePolicyInputs)) {
    packagePolicyInputs.forEach(input => {
      throwIfInputNotAllowed(input.type, input.enabled, supportsAgentless);
    });
  } else {
    Object.keys(packagePolicyInputs).forEach(inputName => {
      var _input$enabled;
      const input = packagePolicyInputs[inputName];
      const match = inputName.match(/\-(\w*)$/);
      const inputType = match && match.length > 0 ? match[1] : '';
      throwIfInputNotAllowed(inputType, (_input$enabled = input === null || input === void 0 ? void 0 : input.enabled) !== null && _input$enabled !== void 0 ? _input$enabled : false, supportsAgentless);
    });
  }
}
function throwIfInputNotAllowed(inputType, inputEnabled, supportsAgentless) {
  if (inputNotAllowedInAgentless(inputType, supportsAgentless) && inputEnabled === true) {
    throw new _errors.PackagePolicyValidationError(`Input ${inputType} is not allowed: types '${_constants.AGENTLESS_DISABLED_INPUTS.map(name => name).join(', ')}' cannot be enabled for an Agentless integration`);
  }
}