"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricRendererFactory = exports.getMetricRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionMetric.renderer.metric.displayName', {
    defaultMessage: 'Metric'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionMetric.renderer.metric.helpDescription', {
    defaultMessage: 'Render a number over a label'
  })
};
const getMetricRenderer = core => () => ({
  name: 'metric',
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      MetricComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/metric_component')));
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
      analytics: undefined
    }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, core, /*#__PURE__*/_react.default.createElement(MetricComponent, {
      label: config.label,
      labelFont: config.labelFont ? config.labelFont.spec : {},
      metric: config.metric,
      metricFont: config.metricFont ? config.metricFont.spec : {},
      metricFormat: config.metricFormat
    })))), domNode, () => handlers.done());
  }
});
exports.getMetricRenderer = getMetricRenderer;
const metricRendererFactory = core => getMetricRenderer(core);
exports.metricRendererFactory = metricRendererFactory;