"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BREAKDOWN_WARNING = exports.BREAKDOWN_UNAVAILABLE = void 0;
exports.Breakdowns = Breakdowns;
exports.NO_BREAK_DOWN_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_series_storage = require("../../hooks/use_series_storage");
var _constants = require("../../configurations/constants");
var _synthetics = require("../../configurations/constants/field_names/synthetics");
var _kpi_over_time_config = require("../../configurations/synthetics/kpi_over_time_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Breakdowns({
  seriesConfig,
  seriesId,
  series
}) {
  const {
    setSeries,
    allSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const indexOfSeriesWithBreakdown = allSeries.findIndex(seriesT => {
    return Boolean(seriesT.breakdown);
  });
  const currentSeriesHasBreakdown = indexOfSeriesWithBreakdown === seriesId;
  const anySeriesHasBreakdown = indexOfSeriesWithBreakdown !== -1;
  const differentSeriesHasBreakdown = anySeriesHasBreakdown && !currentSeriesHasBreakdown;
  const selectedBreakdown = series.breakdown;
  const NO_BREAKDOWN = 'no_breakdown';
  const onOptionChange = optionId => {
    if (optionId === NO_BREAKDOWN) {
      setSeries(seriesId, {
        ...series,
        breakdown: undefined
      });
    } else {
      setSeries(seriesId, {
        ...series,
        breakdown: selectedBreakdown === optionId ? undefined : optionId
      });
    }
  };
  (0, _react.useEffect)(() => {
    if (!(0, _kpi_over_time_config.isStepLevelMetric)(series.selectedMetricField) && selectedBreakdown === _synthetics.SYNTHETICS_STEP_NAME) {
      setSeries(seriesId, {
        ...series,
        breakdown: undefined
      });
    }
  });
  if (!seriesConfig) {
    return null;
  }
  const hasUseBreakdownColumn = seriesConfig.xAxisColumn.sourceField === _constants.USE_BREAK_DOWN_COLUMN;
  const isRecordsMetric = series.selectedMetricField === _constants.RECORDS_FIELD;
  const items = seriesConfig.breakdownFields.map(breakdown => {
    var _seriesConfig$labels$;
    return {
      id: breakdown,
      label: (_seriesConfig$labels$ = seriesConfig.labels[breakdown]) !== null && _seriesConfig$labels$ !== void 0 ? _seriesConfig$labels$ : breakdown
    };
  });
  if (!hasUseBreakdownColumn) {
    items.push({
      id: NO_BREAKDOWN,
      label: NO_BREAK_DOWN_LABEL
    });
  }
  const options = items.map(({
    id,
    label
  }) => {
    if (id === _synthetics.SYNTHETICS_STEP_NAME && !(0, _kpi_over_time_config.isStepLevelMetric)(series.selectedMetricField)) {
      return {
        inputDisplay: label,
        value: id,
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: BREAKDOWN_UNAVAILABLE
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label)),
        disabled: true
      };
    } else {
      return {
        inputDisplay: label,
        value: id,
        dropdownDisplay: label
      };
    }
  }).filter(({
    value
  }) => !(value === _constants.PERCENTILE && isRecordsMetric));
  let valueOfSelected = selectedBreakdown || (hasUseBreakdownColumn ? options[0].value : NO_BREAKDOWN);
  if (selectedBreakdown !== null && selectedBreakdown !== void 0 && selectedBreakdown.startsWith('labels.')) {
    valueOfSelected = _constants.LABEL_FIELDS_BREAKDOWN;
  }
  function Select() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      options: options,
      valueOfSelected: valueOfSelected,
      onChange: value => onOptionChange(value),
      "data-test-subj": 'seriesBreakdown',
      disabled: differentSeriesHasBreakdown
    });
  }
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, differentSeriesHasBreakdown ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: BREAKDOWN_WARNING,
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(Select, null)) : /*#__PURE__*/_react.default.createElement(Select, null));
}
const NO_BREAK_DOWN_LABEL = exports.NO_BREAK_DOWN_LABEL = _i18n.i18n.translate('xpack.exploratoryView.breakDownFilter.noBreakdown', {
  defaultMessage: 'No breakdown'
});
const BREAKDOWN_WARNING = exports.BREAKDOWN_WARNING = _i18n.i18n.translate('xpack.exploratoryView.breakDownFilter.warning', {
  defaultMessage: 'Breakdowns can be applied to only one series at a time.'
});
const BREAKDOWN_UNAVAILABLE = exports.BREAKDOWN_UNAVAILABLE = _i18n.i18n.translate('xpack.exploratoryView.breakDownFilter.unavailable', {
  defaultMessage: 'Step name breakdown is not available for monitor duration metric. Use step duration metric to breakdown by step name.'
});
const Wrapper = _styled.default.span`
  .euiToolTipAnchor {
    width: 100%;
  }
`;