"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsKPIConfig = getLogsKPIConfig;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _infra_logs = require("../constants/field_names/infra_logs");
var _labels = require("../constants/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLogsKPIConfig(configProps) {
  return {
    reportType: _constants.ReportTypes.KPI,
    defaultSeriesType: 'bar',
    seriesTypes: [],
    xAxisColumn: {
      label: _i18n.i18n.translate('xpack.exploratoryView.logs.logRateXAxisLabel', {
        defaultMessage: 'Timestamp'
      }),
      dataType: 'date',
      operationType: 'date_histogram',
      sourceField: '@timestamp',
      isBucketed: true,
      scale: 'interval'
    },
    yAxisColumns: [{
      label: _i18n.i18n.translate('xpack.exploratoryView.logs.logRateYAxisLabel', {
        defaultMessage: 'Log rate per minute'
      }),
      dataType: 'number',
      operationType: 'count',
      isBucketed: false,
      scale: 'ratio',
      sourceField: _constants.RECORDS_FIELD,
      timeScale: 'm'
    }],
    hasOperationType: false,
    filterFields: ['agent.type', 'service.type', 'event.dataset'],
    breakdownFields: ['agent.hostname', 'service.type', 'event.dataset'],
    baseFilters: [],
    definitionFields: ['agent.hostname', 'service.type', 'event.dataset'],
    textDefinitionFields: ['message'],
    metricOptions: [{
      label: _labels.LOG_RATE,
      field: _constants.RECORDS_FIELD,
      id: _infra_logs.LOG_RATE,
      columnType: 'unique_count'
    }],
    labels: {
      ..._constants.FieldLabels
    }
  };
}