"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAction = executeAction;
exports.isActionCompatible = isActionCompatible;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _control_flyout = require("./control_flyout");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function isActionCompatible(queryString) {
  return Boolean(queryString && queryString.trim().length > 0);
}
async function executeAction({
  queryString,
  core,
  search,
  variableType,
  esqlVariables,
  onSaveControl,
  onCancelControl,
  cursorPosition,
  initialState
}) {
  const isCompatibleAction = await isActionCompatible(queryString);
  if (!isCompatibleAction) {
    throw new _public.IncompatibleActionError();
  }
  const deps = await (0, _kibana_services.untilPluginStartServicesReady)();
  const handle = core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.cloneElement(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...deps
    }
  }, /*#__PURE__*/_react.default.createElement(_control_flyout.ESQLControlsFlyout, {
    queryString: queryString,
    search: search,
    variableType: variableType,
    closeFlyout: () => {
      handle.close();
    },
    onSaveControl: onSaveControl,
    onCancelControl: onCancelControl,
    cursorPosition: cursorPosition,
    initialState: initialState,
    esqlVariables: esqlVariables
  }))), {
    closeFlyout: () => {
      handle.close();
    }
  }), core), {
    size: 's',
    'data-test-subj': 'create_esql_control_flyout',
    isResizable: true,
    type: 'push',
    paddingSize: 'm',
    hideCloseButton: true,
    onClose: overlayRef => {
      overlayRef.close();
    },
    outsideClickCloses: true,
    maxWidth: 800
  });
}