"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldControlForm = FieldControlForm;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _esqlUtils = require("@kbn/esql-utils");
var _shared_form_components = require("./shared_form_components");
var _helpers = require("./helpers");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function FieldControlForm({
  variableType,
  initialState,
  queryString,
  esqlVariables,
  cursorPosition,
  onCreateControl,
  onEditControl,
  onCancelControl,
  search,
  closeFlyout
}) {
  var _initialState$title, _initialState$width, _initialState$grow;
  const suggestedVariableName = (0, _react.useMemo)(() => {
    const existingVariables = esqlVariables.filter(variable => variable.type === variableType);
    return initialState ? `${initialState.variableName}` : (0, _helpers.getRecurrentVariableName)('field', existingVariables.map(variable => variable.key));
  }, [esqlVariables, initialState, variableType]);
  const [availableFieldsOptions, setAvailableFieldsOptions] = (0, _react.useState)([]);
  const [selectedFields, setSelectedFields] = (0, _react.useState)(initialState ? initialState.availableOptions.map(option => {
    return {
      label: option,
      key: option,
      'data-test-subj': option
    };
  }) : []);
  const [formIsInvalid, setFormIsInvalid] = (0, _react.useState)(false);
  const [variableName, setVariableName] = (0, _react.useState)(suggestedVariableName);
  const [label, setLabel] = (0, _react.useState)((_initialState$title = initialState === null || initialState === void 0 ? void 0 : initialState.title) !== null && _initialState$title !== void 0 ? _initialState$title : '');
  const [minimumWidth, setMinimumWidth] = (0, _react.useState)((_initialState$width = initialState === null || initialState === void 0 ? void 0 : initialState.width) !== null && _initialState$width !== void 0 ? _initialState$width : 'medium');
  const [grow, setGrow] = (0, _react.useState)((_initialState$grow = initialState === null || initialState === void 0 ? void 0 : initialState.grow) !== null && _initialState$grow !== void 0 ? _initialState$grow : false);
  const isControlInEditMode = (0, _react.useMemo)(() => !!initialState, [initialState]);
  (0, _react.useEffect)(() => {
    if (!availableFieldsOptions.length) {
      const queryForFields = (0, _helpers.getQueryForFields)(queryString, cursorPosition);
      (0, _esqlUtils.getESQLQueryColumnsRaw)({
        esqlQuery: queryForFields,
        search
      }).then(columns => {
        setAvailableFieldsOptions(columns.map(col => {
          return {
            label: col.name,
            key: col.name,
            'data-test-subj': col.name
          };
        }));
      });
    }
  }, [availableFieldsOptions.length, variableType, cursorPosition, queryString, search]);
  (0, _react.useEffect)(() => {
    const variableExists = esqlVariables.some(variable => variable.key === variableName.replace('?', '')) && !isControlInEditMode;
    setFormIsInvalid(!selectedFields.length || !variableName || variableExists);
  }, [esqlVariables, isControlInEditMode, selectedFields.length, variableName]);
  const onFieldsChange = (0, _react.useCallback)(selectedOptions => {
    setSelectedFields(selectedOptions);
  }, []);
  const onVariableNameChange = (0, _react.useCallback)(e => {
    const text = (0, _helpers.validateVariableName)(String(e.target.value));
    setVariableName(text);
  }, []);
  const onLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
  }, []);
  const onMinimumSizeChange = (0, _react.useCallback)(optionId => {
    if (optionId) {
      setMinimumWidth(optionId);
    }
  }, []);
  const onGrowChange = (0, _react.useCallback)(e => {
    setGrow(e.target.checked);
  }, []);
  const onCreateOption = (0, _react.useCallback)((searchValue, flattenedOptions = []) => {
    if (!searchValue.trim()) {
      return;
    }
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    const newOption = {
      label: searchValue,
      key: searchValue,
      'data-test-subj': searchValue
    };
    if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1) {
      setAvailableFieldsOptions([...availableFieldsOptions, newOption]);
    }
    setSelectedFields(prevSelected => [...prevSelected, newOption]);
  }, [availableFieldsOptions]);
  const onCreateFieldControl = (0, _react.useCallback)(async () => {
    const availableOptions = selectedFields.map(field => field.label);
    const state = {
      availableOptions,
      selectedOptions: [availableOptions[0]],
      width: minimumWidth,
      title: label || variableName,
      variableName,
      variableType,
      controlType: _types.EsqlControlType.STATIC_VALUES,
      esqlQuery: queryString,
      grow
    };
    if (availableOptions.length) {
      if (!isControlInEditMode) {
        await onCreateControl(state, variableName);
      } else {
        onEditControl(state);
      }
    }
    closeFlyout();
  }, [selectedFields, minimumWidth, label, variableName, variableType, queryString, grow, isControlInEditMode, closeFlyout, onCreateControl, onEditControl]);
  const styling = (0, _react.useMemo)(() => (0, _helpers.getFlyoutStyling)(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_form_components.Header, {
    isInEditMode: isControlInEditMode
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
          ${styling}
        `
  }, /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlType, {
    isDisabled: true,
    initialControlFlyoutType: _types.EsqlControlType.STATIC_VALUES
  }), /*#__PURE__*/_react.default.createElement(_shared_form_components.VariableName, {
    variableName: variableName,
    isControlInEditMode: isControlInEditMode,
    onVariableNameChange: onVariableNameChange,
    esqlVariables: esqlVariables
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.values.label', {
      defaultMessage: 'Values'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('esql.flyout.fieldsOptions.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    placeholder: _i18n.i18n.translate('esql.flyout.fieldsOptions.placeholder', {
      defaultMessage: 'Select or add values'
    }),
    options: availableFieldsOptions,
    selectedOptions: selectedFields,
    onChange: onFieldsChange,
    onCreateOption: onCreateOption,
    "data-test-subj": "esqlFieldsOptions",
    fullWidth: true,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlLabel, {
    label: label,
    onLabelChange: onLabelChange
  }), /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlWidth, {
    minimumWidth: minimumWidth,
    grow: grow,
    onMinimumSizeChange: onMinimumSizeChange,
    onGrowChange: onGrowChange
  })), /*#__PURE__*/_react.default.createElement(_shared_form_components.Footer, {
    isControlInEditMode: isControlInEditMode,
    variableName: variableName,
    onCancelControl: onCancelControl,
    isSaveDisabled: formIsInvalid,
    closeFlyout: closeFlyout,
    onCreateControl: onCreateFieldControl
  }));
}