"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withOption = exports.onOption = exports.metadataOption = exports.byOption = exports.asOption = exports.appendSeparatorOption = void 0;
var _i18n = require("@kbn/i18n");
var _helpers = require("../shared/helpers");
var _errors = require("../validation/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const byOption = exports.byOption = {
  name: 'by',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.byDoc', {
    defaultMessage: 'By'
  }),
  signature: {
    multipleParams: true,
    params: [{
      name: 'expression',
      type: 'any'
    }]
  },
  optional: true
};
const metadataOption = exports.metadataOption = {
  name: 'metadata',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.metadataDoc', {
    defaultMessage: 'Metadata'
  }),
  signature: {
    multipleParams: true,
    params: [{
      name: 'column',
      type: 'column'
    }]
  },
  optional: true,
  skipCommonValidation: true,
  validate: (option, command, references) => {
    const messages = [];
    const fields = option.args.filter(_helpers.isColumnItem);
    const metadataFieldsAvailable = references;
    if (metadataFieldsAvailable.size > 0) {
      for (const field of fields) {
        if (!metadataFieldsAvailable.has(field.name)) {
          messages.push((0, _errors.getMessageFromId)({
            messageId: 'unknownMetadataField',
            values: {
              value: field.name,
              availableFields: Array.from(metadataFieldsAvailable).join(', ')
            },
            locations: field.location
          }));
        }
      }
    }
    return messages;
  }
};
const asOption = exports.asOption = {
  name: 'as',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.asDoc', {
    defaultMessage: 'As'
  }),
  signature: {
    multipleParams: false,
    params: [{
      name: 'oldName',
      type: 'column'
    }, {
      name: 'newName',
      type: 'column'
    }]
  },
  optional: false
};
const onOption = exports.onOption = {
  name: 'on',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.onDoc', {
    defaultMessage: 'On'
  }),
  signature: {
    multipleParams: false,
    params: [{
      name: 'matchingColumn',
      type: 'column'
    }]
  },
  optional: true
};
const withOption = exports.withOption = {
  name: 'with',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.withDoc', {
    defaultMessage: 'With'
  }),
  signature: {
    multipleParams: true,
    params: [{
      name: 'assignment',
      type: 'any'
    }]
  },
  optional: true
};
const appendSeparatorOption = exports.appendSeparatorOption = {
  name: 'append_separator',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.appendSeparatorDoc', {
    defaultMessage: 'The character(s) that separate the appended fields. Default to empty string ("").'
  }),
  signature: {
    multipleParams: false,
    params: [{
      name: 'separator',
      type: 'string'
    }]
  },
  optional: true,
  skipCommonValidation: true,
  // tell the validation engine to use only the validate function here
  validate: option => {
    const messages = [];
    const [firstArg] = option.args;
    if (!Array.isArray(firstArg) && (!(0, _helpers.isLiteralItem)(firstArg) || firstArg.literalType !== 'keyword')) {
      const value = 'value' in firstArg && !(0, _helpers.isInlineCastItem)(firstArg) ? firstArg.value : firstArg.name;
      messages.push((0, _errors.getMessageFromId)({
        messageId: 'wrongDissectOptionArgumentType',
        values: {
          value: value !== null && value !== void 0 ? value : ''
        },
        locations: firstArg.location
      }));
    }
    return messages;
  }
};