"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPosition = void 0;
var _helpers = require("../../../shared/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getPosition = (innerText, command) => {
  const expressionRoot = command.args[0];
  const endsWithNot = / not$/i.test(innerText.trimEnd());
  if (endsWithNot && !(expressionRoot && (0, _helpers.isFunctionItem)(expressionRoot) &&
  // See https://github.com/elastic/kibana/issues/199401
  // for more information on this check...
  ['is null', 'is not null'].includes(expressionRoot.name))) {
    return 'after_not';
  }
  if (expressionRoot) {
    if ((0, _helpers.isColumnItem)(expressionRoot)) {
      return 'after_column';
    }
    if ((0, _helpers.isFunctionItem)(expressionRoot) && expressionRoot.subtype === 'variadic-call') {
      return 'after_function';
    }
    if ((0, _helpers.isFunctionItem)(expressionRoot) && expressionRoot.subtype !== 'variadic-call') {
      return 'after_operator';
    }
  }
  return 'empty_expression';
};
exports.getPosition = getPosition;