"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _helpers = require("../../../shared/helpers");
var _complete_items = require("../../complete_items");
var _helper = require("../../helper");
var _factories = require("../../factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest(innerText, command, getColumnsByType, columnExists) {
  if (/\s/.test(innerText[innerText.length - 1]) && (0, _helpers.getLastNonWhitespaceChar)(innerText) !== ',' && !(0, _helpers.noCaseCompare)((0, _helpers.findPreviousWord)(innerText), 'keep')) {
    return [_complete_items.pipeCompleteItem, _complete_items.commaCompleteItem];
  }
  const alreadyDeclaredFields = command.args.filter(_helpers.isColumnItem).map(arg => arg.name);
  const fieldSuggestions = await getColumnsByType('any', alreadyDeclaredFields);
  return (0, _helper.handleFragment)(innerText, fragment => columnExists(fragment), (_fragment, rangeToReplace) => {
    // KEEP fie<suggest>
    return fieldSuggestions.map(suggestion => {
      // if there is already a command, we don't want to override it
      if (suggestion.command) return suggestion;
      return {
        ...suggestion,
        text: suggestion.text,
        command: _factories.TRIGGER_SUGGESTION_COMMAND,
        rangeToReplace
      };
    });
  }, (fragment, rangeToReplace) => {
    // KEEP field<suggest>
    const finalSuggestions = [{
      ..._complete_items.pipeCompleteItem,
      text: ' | '
    }];
    if (fieldSuggestions.length > 1)
      // when we fix the editor marker, this should probably be checked against 0 instead of 1
      // this is because the last field in the AST is currently getting removed (because it contains
      // the editor marker) so it is not included in the ignored list which is used to filter out
      // existing fields above.
      finalSuggestions.push({
        ..._complete_items.commaCompleteItem,
        text: ', '
      });
    return finalSuggestions.map(s => ({
      ...s,
      filterText: fragment,
      text: fragment + s.text,
      command: _factories.TRIGGER_SUGGESTION_COMMAND,
      rangeToReplace
    }));
  });
}