"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runESQLQuery = runESQLQuery;
var _apmUtils = require("@kbn/apm-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runESQLQuery(operationName, {
  esClient,
  logger,
  query,
  filter
}) {
  logger.trace(() => `Request (${operationName}):\nquery: ${query}\nfilter: ${JSON.stringify(filter, null, 2)}`);
  return (0, _apmUtils.withSpan)({
    name: operationName,
    labels: {
      plugin: '@kbn/entityManager-plugin'
    }
  }, async () => esClient.esql.query({
    query,
    filter,
    format: 'json'
  }, {
    querystring: {
      drop_null_columns: true
    }
  })).then(response => {
    logger.trace(() => `Response (${operationName}):\n${JSON.stringify(response, null, 2)}`);
    const esqlResponse = response;
    const documents = esqlResponse.values.map(row => rowToObject(row, esqlResponse.columns));
    return documents;
  }).catch(error => {
    logger.trace(() => `Error (${operationName}):\n${error.message}`);
    throw error;
  });
}
function rowToObject(row, columns) {
  return row.reduce((object, value, index) => {
    const column = columns[index];
    if (!column) {
      return object;
    }
    const name = column.name;
    if (!object[name]) {
      object[name] = value;
    }
    return object;
  }, {});
}