"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.identityFieldsBySource = identityFieldsBySource;
var _source_definition = require("./source_definition");
var _unknown_entity_type = require("../errors/unknown_entity_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function identityFieldsBySource(type, clusterClient, logger) {
  const sources = await (0, _source_definition.readSourceDefinitions)(clusterClient, logger, {
    type
  });
  if (sources.length === 0) {
    throw new _unknown_entity_type.UnknownEntityType(`No sources found for type ${type}`);
  }
  const identityFields = {};
  sources.forEach(source => {
    const {
      id,
      identity_fields: fields
    } = source;
    identityFields[id] = fields;
  });
  return identityFields;
}