"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builtInKubernetesClusterEcsEntityDefinition = void 0;
var _constants = require("../../constants");
var _ecs_index_patterns = require("./ecs_index_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const builtInKubernetesClusterEcsEntityDefinition = exports.builtInKubernetesClusterEcsEntityDefinition = {
  type: {
    id: `${_constants.BUILT_IN_ID_PREFIX}kubernetes_cluster_ecs`,
    display_name: 'Kubernetes Clusters (ECS)'
  },
  sources: [{
    id: `${_constants.BUILT_IN_ID_PREFIX}kubernetes_cluster_ecs_ecs`,
    type_id: `${_constants.BUILT_IN_ID_PREFIX}kubernetes_cluster_ecs`,
    index_patterns: _ecs_index_patterns.commonEcsIndexPatterns,
    identity_fields: ['orchestrator.cluster.name'],
    display_name: 'orchestrator.cluster.name',
    timestamp_field: '@timestamp',
    metadata_fields: [],
    filters: ['orchestrator.cluster.name: *']
  }]
};