"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _public = require("@kbn/core/public");
var _ebtTools = require("@kbn/ebt-tools");
var _eui = require("@elastic/eui");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public4 = require("@kbn/entityManager-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _plugin_context = require("./context/plugin_context");
var _overview = require("./pages/overview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderApp({
  core,
  plugins,
  appMountParameters,
  ObservabilityPageTemplate,
  usageCollection,
  isDev,
  kibanaVersion,
  isServerless,
  entityClient
}) {
  var _usageCollection$comp, _plugins$cloud$CloudC, _plugins$cloud;
  const {
    element,
    history,
    theme$
  } = appMountParameters;

  // ensure all divs are .kbnAppWrappers
  element.classList.add(_public.APP_WRAPPER_CLASS);
  const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
  const CloudProvider = (_plugins$cloud$CloudC = (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.CloudContextProvider) !== null && _plugins$cloud$CloudC !== void 0 ? _plugins$cloud$CloudC : _react.default.Fragment;
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$
    }
  }, /*#__PURE__*/_react.default.createElement(CloudProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public3.Storage(localStorage),
      entityClient: new _public4.EntityClient(core),
      isDev,
      kibanaVersion,
      isServerless
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      isDev,
      isServerless,
      appMountParameters,
      ObservabilityPageTemplate,
      entityClient
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: core,
    "data-test-subj": "observabilityMainContainer"
  }, /*#__PURE__*/_react.default.createElement(_ebtTools.PerformanceContextProvider, null, /*#__PURE__*/_react.default.createElement(_overview.EntityManagerOverviewPage, null))))))))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
}