"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountLicensingLogic = exports.LicensingLogic = void 0;
var _kea = require("kea");
var _licensing = require("../../../../common/utils/licensing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicensingLogic = exports.LicensingLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'licensing_logic'],
  actions: {
    setLicense: license => license,
    setLicenseSubscription: licenseSubscription => licenseSubscription
  },
  reducers: ({
    props
  }) => ({
    license: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      setLicense: (_, license) => license
    }],
    licenseSubscription: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      setLicenseSubscription: (_, licenseSubscription) => licenseSubscription
    }],
    canManageLicense: [props.canManageLicense || false, {}]
  }),
  selectors: {
    hasPlatinumLicense: [selectors => [selectors.license], license => (0, _licensing.hasPlatinumLicense)(license)],
    hasEnterpriseLicense: [selectors => [selectors.license], license => (0, _licensing.hasEnterpriseLicense)(license)],
    hasGoldLicense: [selectors => [selectors.license], license => (0, _licensing.hasGoldLicense)(license)],
    isTrial: [selectors => [selectors.license], license => (0, _licensing.isTrialLicense)(license)]
  },
  events: ({
    props,
    actions,
    values
  }) => ({
    afterMount: () => {
      const licenseSubscription = props.license$.subscribe(license => {
        actions.setLicense(license);
      });
      actions.setLicenseSubscription(licenseSubscription);
    },
    beforeUnmount: () => {
      if (values.licenseSubscription) values.licenseSubscription.unsubscribe();
    }
  })
});

/**
 * Mount/props helper
 */

const mountLicensingLogic = props => {
  LicensingLogic(props);
  const unmount = LicensingLogic.mount();
  return unmount;
};
exports.mountLicensingLogic = mountLicensingLogic;