"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesLogic = void 0;
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _flash_messages = require("../../../../shared/flash_messages");
var _get_default_pipeline_api_logic = require("../../../api/connector/get_default_pipeline_api_logic");
var _update_pipeline_api_logic = require("../../../api/connector/update_pipeline_api_logic");
var _cached_fetch_index_api_logic = require("../../../api/index/cached_fetch_index_api_logic");
var _create_custom_pipeline_api_logic = require("../../../api/index/create_custom_pipeline_api_logic");
var _fetch_custom_pipeline_api_logic = require("../../../api/index/fetch_custom_pipeline_api_logic");
var _attach_ml_inference_pipeline = require("../../../api/pipelines/attach_ml_inference_pipeline");
var _create_ml_inference_pipeline = require("../../../api/pipelines/create_ml_inference_pipeline");
var _delete_ml_inference_pipeline = require("../../../api/pipelines/delete_ml_inference_pipeline");
var _detach_ml_inference_pipeline = require("../../../api/pipelines/detach_ml_inference_pipeline");
var _fetch_ml_inference_pipeline_processors = require("../../../api/pipelines/fetch_ml_inference_pipeline_processors");
var _revert_connector_pipeline_api_logic = require("../../../api/pipelines/revert_connector_pipeline_api_logic");
var _indices = require("../../../utils/indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelinesLogic = exports.PipelinesLogic = (0, _kea.kea)({
  actions: {
    closeAddMlInferencePipelineModal: true,
    closeDeleteModal: true,
    closePipelineSettings: true,
    openAddMlInferencePipelineModal: true,
    openDeleteModal: true,
    openPipelineSettings: true,
    savePipeline: true,
    setPipelineState: pipeline => ({
      pipeline
    })
  },
  connect: {
    actions: [_create_custom_pipeline_api_logic.CreateCustomPipelineApiLogic, ['apiError as createCustomPipelineError', 'apiSuccess as createCustomPipelineSuccess', 'makeRequest as createCustomPipeline'], _update_pipeline_api_logic.UpdatePipelineApiLogic, ['apiSuccess', 'apiError', 'makeRequest'], _cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['apiSuccess as fetchIndexApiSuccess'], _get_default_pipeline_api_logic.FetchDefaultPipelineApiLogic, ['apiSuccess as fetchDefaultPipelineSuccess', 'makeRequest as fetchDefaultPipeline'], _fetch_custom_pipeline_api_logic.FetchCustomPipelineApiLogic, ['apiSuccess as fetchCustomPipelineSuccess', 'makeRequest as fetchCustomPipeline'], _fetch_ml_inference_pipeline_processors.FetchMlInferencePipelineProcessorsApiLogic, ['makeRequest as fetchMlInferenceProcessors', 'apiError as fetchMlInferenceProcessorsApiError'], _attach_ml_inference_pipeline.AttachMlInferencePipelineApiLogic, ['apiSuccess as attachMlInferencePipelineSuccess'], _create_ml_inference_pipeline.CreateMlInferencePipelineApiLogic, ['apiSuccess as createMlInferencePipelineSuccess'], _delete_ml_inference_pipeline.DeleteMlInferencePipelineApiLogic, ['apiError as deleteMlPipelineError', 'apiSuccess as deleteMlPipelineSuccess', 'makeRequest as deleteMlPipeline'], _detach_ml_inference_pipeline.DetachMlInferencePipelineApiLogic, ['apiError as detachMlPipelineError', 'apiSuccess as detachMlPipelineSuccess', 'makeRequest as detachMlPipeline'], _revert_connector_pipeline_api_logic.RevertConnectorPipelineApilogic, ['apiSuccess as revertPipelineSuccess']],
    values: [_fetch_custom_pipeline_api_logic.FetchCustomPipelineApiLogic, ['data as customPipelineData'], _get_default_pipeline_api_logic.FetchDefaultPipelineApiLogic, ['data as defaultPipelineValuesData'], _cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['fetchIndexApiData as index'], _fetch_ml_inference_pipeline_processors.FetchMlInferencePipelineProcessorsApiLogic, ['data as mlInferencePipelineProcessors']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    apiSuccess: ({
      pipeline
    }) => {
      if ((0, _indices.isConnectorIndex)(values.index)) {
        if (values.index.connector) {
          // had to split up these if checks rather than nest them or typescript wouldn't recognize connector as defined
          actions.fetchIndexApiSuccess({
            ...values.index,
            connector: {
              ...values.index.connector,
              pipeline
            }
          });
        }
      }
    },
    attachMlInferencePipelineSuccess: () => {
      // Re-fetch processors to ensure we display newly added ml processor
      actions.fetchMlInferenceProcessors({
        indexName: values.index.name
      });
      // Needed to ensure correct JSON is available in the JSON configurations tab
      actions.fetchCustomPipeline({
        indexName: values.index.name
      });
    },
    closePipelineSettings: () => {
      var _values$index$connect, _values$index$connect2;
      return actions.setPipelineState((0, _indices.isConnectorIndex)(values.index) ? (_values$index$connect = (_values$index$connect2 = values.index.connector) === null || _values$index$connect2 === void 0 ? void 0 : _values$index$connect2.pipeline) !== null && _values$index$connect !== void 0 ? _values$index$connect : values.defaultPipelineValues : values.defaultPipelineValues);
    },
    createCustomPipelineSuccess: created => {
      actions.fetchCustomPipelineSuccess(created);
      actions.setPipelineState({
        ...values.pipelineState,
        name: values.indexName
      });
      actions.savePipeline();
      actions.fetchCustomPipeline({
        indexName: values.index.name
      });
    },
    createMlInferencePipelineSuccess: () => {
      // Re-fetch processors to ensure we display newly added ml processor
      actions.fetchMlInferenceProcessors({
        indexName: values.index.name
      });
      // Needed to ensure correct JSON is available in the JSON configurations tab
      actions.fetchCustomPipeline({
        indexName: values.index.name
      });
    },
    deleteMlPipelineSuccess: value => {
      if (value.deleted) {
        (0, _flash_messages.flashSuccessToast)(_i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.successToastDeleteMlPipeline.title', {
          defaultMessage: 'Deleted machine learning inference pipeline "{pipelineName}"',
          values: {
            pipelineName: value.deleted
          }
        }));
      }
      // Re-fetch processors to ensure we display newly removed ml processor
      actions.fetchMlInferenceProcessors({
        indexName: values.index.name
      });
      // Needed to ensure correct JSON is available in the JSON configurations tab
      actions.fetchCustomPipeline({
        indexName: values.index.name
      });
    },
    detachMlPipelineSuccess: response => {
      if (response.updated) {
        (0, _flash_messages.flashSuccessToast)(_i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.successToastDetachMlPipeline.title', {
          defaultMessage: 'Detached machine learning inference pipeline from "{pipelineName}"',
          values: {
            pipelineName: response.updated
          }
        }));
      }
      // Re-fetch processors to ensure we display newly removed ml processor
      actions.fetchMlInferenceProcessors({
        indexName: values.index.name
      });
      // Needed to ensure correct JSON is available in the JSON configurations tab
      actions.fetchCustomPipeline({
        indexName: values.index.name
      });
    },
    fetchIndexApiSuccess: index => {
      if (!values.showPipelineSettings) {
        var _index$connector;
        // Don't do this when the modal is open to avoid overwriting the values while editing
        const pipeline = (0, _indices.isConnectorIndex)(index) ? (_index$connector = index.connector) === null || _index$connector === void 0 ? void 0 : _index$connector.pipeline : values.defaultPipelineValues;
        actions.setPipelineState(pipeline !== null && pipeline !== void 0 ? pipeline : values.defaultPipelineValues);
      }
    },
    openPipelineSettings: () => {
      var _values$index$connect3;
      const pipeline = (0, _indices.isConnectorIndex)(values.index) ? (_values$index$connect3 = values.index.connector) === null || _values$index$connect3 === void 0 ? void 0 : _values$index$connect3.pipeline : values.defaultPipelineValues;
      actions.setPipelineState(pipeline !== null && pipeline !== void 0 ? pipeline : values.defaultPipelineValues);
    },
    revertPipelineSuccess: () => {
      if ((0, _indices.isConnectorIndex)(values.index)) {
        if (values.index.connector) {
          // had to split up these if checks rather than nest them or typescript wouldn't recognize connector as defined
          actions.fetchIndexApiSuccess({
            ...values.index,
            connector: {
              ...values.index.connector,
              pipeline: values.defaultPipelineValues
            }
          });
          actions.fetchCustomPipelineSuccess({});
        }
      }
      actions.fetchCustomPipeline({
        indexName: values.indexName
      });
    },
    savePipeline: () => {
      if ((0, _indices.isConnectorIndex)(values.index)) {
        if (values.index.connector) {
          var _values$index$connect4;
          actions.makeRequest({
            connectorId: (_values$index$connect4 = values.index.connector) === null || _values$index$connect4 === void 0 ? void 0 : _values$index$connect4.id,
            pipeline: values.pipelineState
          });
        }
      }
    }
  }),
  path: ['enterprise_search', 'content', 'pipelines'],
  reducers: () => ({
    isDeleteModalOpen: [false, {
      closeDeleteModal: () => false,
      openDeleteModal: () => true,
      revertPipelineSuccess: () => false
    }],
    pipelineState: [_constants.DEFAULT_PIPELINE_VALUES, {
      // @ts-expect-error upgrade typescript v5.1.6
      setPipelineState: (_, {
        pipeline
      }) => pipeline
    }],
    showAddMlInferencePipelineModal: [false, {
      attachMlInferencePipelineSuccess: () => false,
      closeAddMlInferencePipelineModal: () => false,
      createMlInferencePipelineSuccess: () => false,
      openAddMlInferencePipelineModal: () => true
    }],
    showPipelineSettings: [false, {
      apiSuccess: () => false,
      closePipelineSettings: () => false,
      openPipelineSettings: () => true
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    canSetPipeline: [() => [selectors.index], index => !(0, _indices.isApiIndex)(index)],
    canUseMlInferencePipeline: [() => [selectors.hasIndexIngestionPipeline, selectors.pipelineState, selectors.index], (hasIndexIngestionPipeline, pipelineState, index) => hasIndexIngestionPipeline && (pipelineState.run_ml_inference || (0, _indices.isApiIndex)(index))],
    defaultPipelineValues: [() => [selectors.defaultPipelineValuesData], pipeline => pipeline !== null && pipeline !== void 0 ? pipeline : _constants.DEFAULT_PIPELINE_VALUES],
    hasIndexIngestionPipeline: [() => [selectors.pipelineName, selectors.defaultPipelineValues], (pipelineName, defaultPipelineValues) => pipelineName !== defaultPipelineValues.name],
    indexName: [() => [selectors.index], index => {
      var _index$name;
      return (_index$name = index === null || index === void 0 ? void 0 : index.name) !== null && _index$name !== void 0 ? _index$name : '';
    }],
    pipelineName: [() => [selectors.pipelineState, selectors.customPipelineData, selectors.indexName], (pipelineState, customPipelineData, indexName) => customPipelineData && customPipelineData[indexName] ? indexName : pipelineState.name],
    showMissingPipelineCallout: [() => [selectors.hasIndexIngestionPipeline, selectors.pipelineName, selectors.customPipelineData, selectors.index], (hasCustomPipeline, pipelineName, customPipelineData, index) => Boolean(hasCustomPipeline && customPipelineData && !customPipelineData[pipelineName] && (0, _indices.isConnectorIndex)(index))]
  })
});