"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewConnectorLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../common/types/api");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _add_connector_api_logic = require("../../../api/connector/add_connector_api_logic");
var _generate_connector_config_api_logic = require("../../../api/connector/generate_connector_config_api_logic");
var _generate_connector_names_api_logic = require("../../../api/connector/generate_connector_names_api_logic");
var _routes = require("../../../routes");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _search_index = require("../../search_index/search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewConnectorLogic = exports.NewConnectorLogic = (0, _kea.kea)({
  actions: {
    createConnector: ({
      isSelfManaged,
      shouldGenerateAfterCreate,
      shouldNavigateToConnectorAfterCreate
    }) => ({
      isSelfManaged,
      shouldGenerateAfterCreate,
      shouldNavigateToConnectorAfterCreate
    }),
    setCurrentStep: step => ({
      step
    }),
    setFormDirty: isDirty => ({
      isDirty
    }),
    setRawName: rawName => ({
      rawName
    }),
    setSelectedConnector: connector => ({
      connector
    })
  },
  connect: {
    actions: [_generate_connector_names_api_logic.GenerateConnectorNamesApiLogic, ['makeRequest as generateConnectorName', 'apiSuccess as connectorNameGenerated'], _add_connector_api_logic.AddConnectorApiLogic, ['makeRequest as createConnectorApi', 'apiSuccess as connectorCreated'], _generate_connector_config_api_logic.GenerateConfigApiLogic, ['makeRequest as generateConfiguration', 'apiSuccess as configurationGenerated'], _connector_view_logic.ConnectorViewLogic, ['fetchConnector']],
    values: [_generate_connector_names_api_logic.GenerateConnectorNamesApiLogic, ['data as generatedNameData'], _generate_connector_config_api_logic.GenerateConfigApiLogic, ['data as generatedConfigData', 'status as generateConfigurationStatus'], _add_connector_api_logic.AddConnectorApiLogic, ['status as createConnectorApiStatus']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    connectorCreated: ({
      id,
      uiFlags
    }) => {
      if (uiFlags !== null && uiFlags !== void 0 && uiFlags.shouldNavigateToConnectorAfterCreate) {
        _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
          connectorId: id,
          tabId: _search_index.SearchIndexTabId.CONFIGURATION
        }));
      } else {
        actions.fetchConnector({
          connectorId: id
        });
        if (!uiFlags || uiFlags.shouldGenerateAfterCreate) {
          actions.generateConfiguration({
            connectorId: id
          });
        }
      }
    },
    connectorNameGenerated: ({
      connectorName
    }) => {
      actions.setRawName(connectorName);
    },
    createConnector: ({
      isSelfManaged,
      shouldGenerateAfterCreate = true,
      shouldNavigateToConnectorAfterCreate = false
    }) => {
      if (!values.rawName && values.selectedConnector && values.connectorName && values.generatedNameData) {
        // name is generated, use everything generated
        actions.createConnectorApi({
          deleteExistingConnector: false,
          indexName: values.connectorName,
          isNative: !values.selectedConnector.isNative ? false : !isSelfManaged,
          language: null,
          name: values.generatedNameData.connectorName,
          serviceType: values.selectedConnector.serviceType,
          uiFlags: {
            shouldGenerateAfterCreate,
            shouldNavigateToConnectorAfterCreate
          }
        });
      } else {
        if (values.generatedNameData && values.selectedConnector) {
          var _values$selectedConne;
          actions.createConnectorApi({
            deleteExistingConnector: false,
            indexName: values.generatedNameData.indexName,
            isNative: !values.selectedConnector.isNative ? false : !isSelfManaged,
            language: null,
            name: values.connectorName,
            serviceType: (_values$selectedConne = values.selectedConnector) === null || _values$selectedConne === void 0 ? void 0 : _values$selectedConne.serviceType,
            uiFlags: {
              shouldGenerateAfterCreate,
              shouldNavigateToConnectorAfterCreate
            }
          });
        }
      }
    },
    setSelectedConnector: ({
      connector
    }) => {
      if (connector) {
        actions.generateConnectorName({
          connectorType: connector.serviceType,
          isManagedConnector: connector.isNative
        });
      }
    }
  }),
  path: ['enterprise_search', 'content', 'new_search_connector'],
  reducers: {
    connectorId: ['', {
      connectorCreated: (_, {
        id
      }) => id
    }],
    currentStep: ['start', {
      setCurrentStep: (_, {
        step
      }) => step
    }],
    isFormDirty: [false,
    // Initial state (form is not dirty)
    {
      // @ts-expect-error upgrade typescript v5.1.6
      setFormDirty: (_, {
        isDirty
      }) => isDirty
    }],
    rawName: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      setRawName: (_, {
        rawName
      }) => rawName
    }],
    selectedConnector: [null, {
      setSelectedConnector: (_, {
        connector
      }) => connector
    }]
  },
  selectors: ({
    selectors
  }) => ({
    canConfigureConnector: [() => [selectors.connectorName, selectors.selectedConnector], (connectorName, selectedConnector) => {
      var _ref;
      return (_ref = connectorName && (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.name)) !== null && _ref !== void 0 ? _ref : false;
    }],
    connectorName: [() => [selectors.rawName, selectors.generatedNameData], (name, generatedName) => {
      var _generatedName$connec;
      return name ? name : (_generatedName$connec = generatedName === null || generatedName === void 0 ? void 0 : generatedName.connectorName) !== null && _generatedName$connec !== void 0 ? _generatedName$connec : '';
    }],
    isCreateLoading: [() => [selectors.createConnectorApiStatus], status => status === _api.Status.LOADING],
    isGenerateLoading: [() => [selectors.generateConfigurationStatus], status => status === _api.Status.LOADING]
  })
});