"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDetailOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _encode_path_params = require("../../../shared/encode_path_params");
var _eui_components = require("../../../shared/react_router_helpers/eui_components");
var _routes = require("../../routes");
var _convert_connector_logic = require("../search_index/connector/native_connector_configuration/convert_connector_logic");
var _index_view_logic = require("../search_index/index_view_logic");
var _sync_jobs = require("../search_index/sync_jobs/sync_jobs");
var _convert_connector_modal = require("../shared/convert_connector_modal/convert_connector_modal");
var _connector_detail = require("./connector_detail");
var _connector_stats = require("./connector_stats");
var _connector_view_logic = require("./connector_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorDetailOverview = () => {
  const {
    indexData
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    connector,
    error,
    connectorAgentlessPolicy
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    showModal
  } = (0, _kea.useActions)(_convert_connector_logic.ConvertConnectorLogic);
  const {
    isModalVisible
  } = (0, _kea.useValues)(_convert_connector_logic.ConvertConnectorLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null,
  // TODO remove this callout when example status is removed
  connector && connector.service_type && _constants.EXAMPLE_CONNECTOR_SERVICE_TYPES.includes(connector.service_type) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.connectorUnsupportedCallOut.title', {
      defaultMessage: 'Example connector'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connectors.overview.connectorUnsupportedCallOut.description",
    defaultMessage: "This is an example connector that serves as a building block for customizations. The design and code is being provided as-is with no warranties. This is not subject to the SLA of supported features."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), (connector === null || connector === void 0 ? void 0 : connector.is_native) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(_convert_connector_modal.ConvertConnectorModal, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.nativeCloudCallout.title', {
      defaultMessage: 'Elastic managed connectors are no longer supported'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connectors.overview.nativeCloudCallout.content",
    defaultMessage: "Elastic managed connectors are no longer supported. Convert it to a {link} to continue using it.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "entSearchContent-connectorDetailOverview-nativeCloudCallout-connectorClientLink",
        "data-telemetry-id": "entSearchContent-connectorDetailOverview-nativeCloudCallout-connectorClientLink",
        href: _doc_links.docLinks.buildConnector,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.nativeCloudCallout.connectorClient', {
        defaultMessage: 'self-managed connector'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connectorDetailOverview-nativeCloudCallout-convertToSelfManagedClientButton",
    color: "warning",
    fill: true,
    onClick: () => showModal()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectors.overview.convertConnector.buttonLabel', {
    defaultMessage: 'Convert connector'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.connectorErrorCallOut.title', {
      defaultMessage: 'Your connector has reported an error'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), !!connector && !connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.connectorNoIndexCallOut.title', {
      defaultMessage: 'Connector has no attached index'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.connectorNoIndexCallOut.description', {
    defaultMessage: "You won't be able to start syncing content until your connector is attached to an index."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui_components.EuiButtonTo, {
    color: "warning",
    fill: true,
    to: `${(0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId: connector.id,
      tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
    })}#attachIndexBox`
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.connectorNoIndexCallOut.buttonLabel', {
    defaultMessage: 'Attach index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), !!(connector !== null && connector !== void 0 && connector.index_name) && !indexData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.connectorIndexDoesntExistCallOut.title', {
      defaultMessage: "Attached index doesn't exist"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connectors.overview.connectorIndexDoesntExistCallOut.description",
    defaultMessage: "The connector will create the index on its next sync, or you can manually create the index {indexName} with your desired settings and mappings.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, connector.index_name)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), connector && !connector.is_native && connector.service_type !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE && /*#__PURE__*/_react.default.createElement(_connector_stats.ConnectorStats, {
    connector: connector,
    indexData: indexData || undefined,
    agentlessOverview: connectorAgentlessPolicy
  }), connector && !connector.is_native && connector.service_type !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_jobs.SyncJobs, {
    connector: connector
  })));
};
exports.ConnectorDetailOverview = ConnectorDetailOverview;