"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionDataViewLogic = void 0;
var _kea = require("kea");
var _find_or_create_data_view = require("../../utils/find_or_create_data_view");
var _fetch_analytics_collection_logic = require("./fetch_analytics_collection_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionDataViewLogic = exports.AnalyticsCollectionDataViewLogic = (0, _kea.kea)({
  actions: {
    setDataView: dataView => ({
      dataView
    })
  },
  connect: {
    actions: [_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic, ['apiSuccess as fetchedAnalyticsCollection']]
  },
  listeners: ({
    actions
  }) => ({
    fetchedAnalyticsCollection: async collection => {
      const dataView = await (0, _find_or_create_data_view.findOrCreateDataView)(collection);
      if (dataView) {
        actions.setDataView(dataView);
      }
    }
  }),
  path: ['enterprise_search', 'analytics', 'collection', 'dataView'],
  reducers: () => ({
    // @ts-expect-error upgrade typescript v5.1.6
    dataView: [null, {
      setDataView: (_, {
        dataView
      }) => dataView
    }]
  })
});