"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_EXPERIENCES_PLUGIN = exports.SEARCH_APPS_BREADCRUMB = exports.READ_ONLY_MODE_HEADER = exports.PLUGIN_ID = exports.PLAYGROUND_URL = exports.MANAGE_API_KEYS_URL = exports.LICENSED_SUPPORT_URL = exports.JSON_HEADER = exports.INGESTION_METHOD_IDS = exports.GETTING_STARTED_TITLE = exports.EXAMPLE_CONNECTOR_SERVICE_TYPES = exports.ERROR_CONNECTING_HEADER = exports.ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID = exports.ENTERPRISE_SEARCH_PRODUCT_NAME = exports.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN = exports.ENTERPRISE_SEARCH_KIBANA_COOKIE = exports.ENTERPRISE_SEARCH_ELASTICSEARCH_URL = exports.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = exports.ENTERPRISE_SEARCH_CONTENT_PLUGIN = exports.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = exports.ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID = exports.ENTERPRISE_SEARCH_ANALYTICS_LOGS_SOURCE_ID = exports.ELASTICSEARCH_PLUGIN = exports.DEFAULT_PRODUCT_FEATURES = exports.DEFAULT_PIPELINE_VALUES = exports.DEFAULT_PIPELINE_NAME = exports.CREATE_NEW_INDEX_URL = exports.CREATE_CONNECTOR_PLUGIN = exports.CRAWLER = exports.CONNECTOR_NATIVE_TYPE = exports.CONNECTOR_CLIENTS_TYPE = exports.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX = exports.APP_SEARCH_URL = exports.APPLICATIONS_PLUGIN = exports.ANALYTICS_PLUGIN = exports.AI_SEARCH_PLUGIN = void 0;
Object.defineProperty(exports, "SEARCH_INDICES", {
  enumerable: true,
  get: function () {
    return _deeplinksSearch.SEARCH_INDICES;
  }
});
Object.defineProperty(exports, "SEARCH_INDICES_START", {
  enumerable: true,
  get: function () {
    return _deeplinksSearch.SEARCH_INDICES_START;
  }
});
exports.defaultConnectorsPipelineMeta = exports.WORKPLACE_SEARCH_URL = exports.VECTOR_SEARCH_PLUGIN = exports.SEMANTIC_SEARCH_PLUGIN = exports.SEARCH_PRODUCT_NAME = void 0;
var _dedent = _interopRequireDefault(require("dedent"));
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_PRODUCT_NAME = exports.SEARCH_PRODUCT_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.search.productName', {
  defaultMessage: 'Elasticsearch'
});
const ENTERPRISE_SEARCH_PRODUCT_NAME = exports.ENTERPRISE_SEARCH_PRODUCT_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.productName', {
  defaultMessage: 'Enterprise Search'
});
const ENTERPRISE_SEARCH_OVERVIEW_PLUGIN = exports.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN = {
  ID: _deeplinksSearch.ENTERPRISE_SEARCH_APP_ID,
  NAME: SEARCH_PRODUCT_NAME,
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.overview.navTitle', {
    defaultMessage: 'Overview'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.overview.description', {
    defaultMessage: 'Create search experiences with a refined set of APIs and tools.'
  }),
  URL: '/app/elasticsearch/overview',
  LOGO: 'logoElasticsearch'
};
const ENTERPRISE_SEARCH_CONTENT_PLUGIN = exports.ENTERPRISE_SEARCH_CONTENT_PLUGIN = {
  ID: _deeplinksSearch.ENTERPRISE_SEARCH_CONTENT_APP_ID,
  NAME: SEARCH_PRODUCT_NAME,
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.content.navTitle', {
    defaultMessage: 'Content'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.content.description', {
    defaultMessage: 'Enterprise search offers a number of ways to easily make your data searchable. Choose from the web crawler, Elasticsearch indices, API, direct uploads, or thrid party connectors.' // TODO: Make sure this content is correct.
  }),
  URL: '/app/elasticsearch/content',
  LOGO: 'logoElasticsearch',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/'
};
const AI_SEARCH_PLUGIN = exports.AI_SEARCH_PLUGIN = {
  ID: _deeplinksSearch.SEARCH_AI_SEARCH,
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.productName', {
    defaultMessage: 'AI Search'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.navTitle', {
    defaultMessage: 'AI Search'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.description', {
    defaultMessage: 'Toolkit for enabling developers to build AI search-powered applications using the Elastic platform.'
  }),
  URL: '/app/elasticsearch/ai_search',
  LOGO: 'logoElasticsearch'
};
const ANALYTICS_PLUGIN = exports.ANALYTICS_PLUGIN = {
  ID: _deeplinksSearch.ENTERPRISE_SEARCH_ANALYTICS_APP_ID,
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.productName', {
    defaultMessage: 'Behavioral Analytics'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.productDescription', {
    defaultMessage: 'Dashboards and tools for visualizing end-user behavior and measuring the performance of your search applications.'
  }),
  CARD_DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.productCardDescription', {
    defaultMessage: 'Dashboards and tools for visualizing end-user behavior and measuring the performance of your search applications.'
  }),
  URL: '/app/elasticsearch/analytics',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/'
};
const ELASTICSEARCH_PLUGIN = exports.ELASTICSEARCH_PLUGIN = {
  ID: _deeplinksSearch.SEARCH_ELASTICSEARCH,
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.productName', {
    defaultMessage: 'Elasticsearch'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.productDescription', {
    defaultMessage: 'Low-level tools for creating performant and relevant search experiences.'
  }),
  URL: '/app/elasticsearch/elasticsearch',
  SUPPORT_URL: 'https://discuss.elastic.co/c/elastic-stack/elasticsearch/'
};
const SEARCH_EXPERIENCES_PLUGIN = exports.SEARCH_EXPERIENCES_PLUGIN = {
  ID: 'searchExperiences',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.productName', {
    defaultMessage: 'Search Experiences'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.navTitle', {
    defaultMessage: 'Search Experiences'
  }),
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.productDescription', {
    defaultMessage: 'Build an intuitive, engaging search experience without reinventing the wheel.'
  }),
  URL: '/app/enterprise_search/search_experiences',
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/',
  GITHUB_URL: 'https://github.com/elastic/search-ui/',
  DOCUMENTATION_URL: 'https://docs.elastic.co/search-ui/',
  ELASTICSEARCH_TUTORIAL_URL: 'https://docs.elastic.co/search-ui/tutorials/elasticsearch',
  APP_SEARCH_TUTORIAL_URL: 'https://docs.elastic.co/search-ui/tutorials/app-search',
  WORKPLACE_SEARCH_TUTORIAL_URL: 'https://docs.elastic.co/search-ui/tutorials/workplace-search'
};
const APPLICATIONS_PLUGIN = exports.APPLICATIONS_PLUGIN = {
  ID: _deeplinksSearch.ENTERPRISE_SEARCH_APPLICATIONS_APP_ID,
  LOGO: 'logoElasticsearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.applications.productName', {
    defaultMessage: 'Applications'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.applications.navTitle', {
    defaultMessage: 'Build'
  }),
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/',
  URL: '/app/elasticsearch/applications'
};
const VECTOR_SEARCH_PLUGIN = exports.VECTOR_SEARCH_PLUGIN = {
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.vectorSearch.description', {
    defaultMessage: 'Elasticsearch can be used as a vector database, which enables vector search and semantic search use cases.'
  }),
  ID: _deeplinksSearch.SEARCH_VECTOR_SEARCH,
  LOGO: 'logoElasticsearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.vectorSearch.productName', {
    defaultMessage: 'Vector Search'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.vectorSearch.navTitle', {
    defaultMessage: 'Vector Search'
  }),
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/',
  URL: '/app/elasticsearch/vector_search'
};
const SEMANTIC_SEARCH_PLUGIN = exports.SEMANTIC_SEARCH_PLUGIN = {
  DESCRIPTION: _i18n.i18n.translate('xpack.enterpriseSearch.SemanticSearch.description', {
    defaultMessage: 'Easily add semantic search to Elasticsearch with inference endpoints and the semantic_text field type, to boost search relevance.'
  }),
  ID: _deeplinksSearch.SEARCH_SEMANTIC_SEARCH,
  LOGO: 'logoElasticsearch',
  NAME: _i18n.i18n.translate('xpack.enterpriseSearch.SemanticSearch.productName', {
    defaultMessage: 'Semantic Search'
  }),
  NAV_TITLE: _i18n.i18n.translate('xpack.enterpriseSearch.SemanticSearch.navTitle', {
    defaultMessage: 'Semantic Search'
  }),
  SUPPORT_URL: 'https://discuss.elastic.co/c/enterprise-search/',
  URL: '/app/elasticsearch/semantic_search'
};
const CREATE_CONNECTOR_PLUGIN = exports.CREATE_CONNECTOR_PLUGIN = {
  CLI_SNIPPET: (0, _dedent.default)`./bin/connectors connector create
  --index-name my-index
  --index-language en
  --from-file config.yml
  `
};
const LICENSED_SUPPORT_URL = exports.LICENSED_SUPPORT_URL = 'https://support.elastic.co';
const JSON_HEADER = exports.JSON_HEADER = {
  'Content-Type': 'application/json',
  // This needs specific casing or Chrome throws a 415 error
  Accept: 'application/json' // Required for Enterprise Search APIs
};
const ERROR_CONNECTING_HEADER = exports.ERROR_CONNECTING_HEADER = 'x-ent-search-error-connecting';
const READ_ONLY_MODE_HEADER = exports.READ_ONLY_MODE_HEADER = 'x-ent-search-read-only-mode';
const ENTERPRISE_SEARCH_KIBANA_COOKIE = exports.ENTERPRISE_SEARCH_KIBANA_COOKIE = '_enterprise_search';
const ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID = exports.ENTERPRISE_SEARCH_RELEVANCE_LOGS_SOURCE_ID = 'ent-search-logs';
const ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID = exports.ENTERPRISE_SEARCH_AUDIT_LOGS_SOURCE_ID = 'ent-search-audit-logs';
const ENTERPRISE_SEARCH_ANALYTICS_LOGS_SOURCE_ID = exports.ENTERPRISE_SEARCH_ANALYTICS_LOGS_SOURCE_ID = 'ent-search-analytics-logs';
const APP_SEARCH_URL = exports.APP_SEARCH_URL = '/app/enterprise_search/app_search';
const ENTERPRISE_SEARCH_ELASTICSEARCH_URL = exports.ENTERPRISE_SEARCH_ELASTICSEARCH_URL = '/app/elasticsearch/elasticsearch';
const WORKPLACE_SEARCH_URL = exports.WORKPLACE_SEARCH_URL = '/app/enterprise_search/workplace_search';
const CREATE_NEW_INDEX_URL = exports.CREATE_NEW_INDEX_URL = '/search_indices/new_index';
const PLAYGROUND_URL = exports.PLAYGROUND_URL = '/playground';
const MANAGE_API_KEYS_URL = exports.MANAGE_API_KEYS_URL = '/app/management/security/api_keys';
const ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = exports.ENTERPRISE_SEARCH_DOCUMENTS_DEFAULT_DOC_COUNT = 25;

// TODO: Remove?
const ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = exports.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE = 'elastic-crawler';
const DEFAULT_PIPELINE_NAME = exports.DEFAULT_PIPELINE_NAME = 'search-default-ingestion';
const DEFAULT_PIPELINE_VALUES = exports.DEFAULT_PIPELINE_VALUES = {
  extract_binary_content: true,
  name: DEFAULT_PIPELINE_NAME,
  reduce_whitespace: true,
  run_ml_inference: true
};
const defaultConnectorsPipelineMeta = exports.defaultConnectorsPipelineMeta = {
  default_extract_binary_content: DEFAULT_PIPELINE_VALUES.extract_binary_content,
  default_name: DEFAULT_PIPELINE_NAME,
  default_reduce_whitespace: DEFAULT_PIPELINE_VALUES.reduce_whitespace,
  default_run_ml_inference: DEFAULT_PIPELINE_VALUES.run_ml_inference
};
let INGESTION_METHOD_IDS = exports.INGESTION_METHOD_IDS = /*#__PURE__*/function (INGESTION_METHOD_IDS) {
  INGESTION_METHOD_IDS["API"] = "api";
  INGESTION_METHOD_IDS["CONNECTOR"] = "connector";
  return INGESTION_METHOD_IDS;
}({});
const DEFAULT_PRODUCT_FEATURES = exports.DEFAULT_PRODUCT_FEATURES = {
  hasConnectors: true,
  hasDefaultIngestPipeline: true,
  hasDocumentLevelSecurityEnabled: true,
  hasIncrementalSyncEnabled: true,
  hasNativeConnectors: true,
  hasWebCrawler: true
};
const CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX = exports.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX = '.search-acl-filter-';
const PLUGIN_ID = exports.PLUGIN_ID = 'enterpriseSearch';
const CONNECTOR_NATIVE_TYPE = exports.CONNECTOR_NATIVE_TYPE = 'native';
const CONNECTOR_CLIENTS_TYPE = exports.CONNECTOR_CLIENTS_TYPE = 'connector_clients';
const CRAWLER = exports.CRAWLER = {
  github_repo: 'https://github.com/elastic/crawler'
};

// TODO remove this once the connector service types are no longer in "example" state
const EXAMPLE_CONNECTOR_SERVICE_TYPES = exports.EXAMPLE_CONNECTOR_SERVICE_TYPES = ['opentext_documentum'];
const GETTING_STARTED_TITLE = exports.GETTING_STARTED_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.gettingStarted.title', {
  defaultMessage: 'Getting started'
});
const SEARCH_APPS_BREADCRUMB = exports.SEARCH_APPS_BREADCRUMB = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.breadcrumb', {
  defaultMessage: 'Search Applications'
});