"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactEmbeddableRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/presentation-panel-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _react_embeddable_registry = require("./react_embeddable_registry");
var _phase_tracker = require("./phase_tracker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ON_STATE_CHANGE_DEBOUNCE = 100;

/**
 * Renders a component from the React Embeddable registry into a Presentation Panel.
 *
 * TODO: Rename this to simply `Embeddable` when the legacy Embeddable system is removed.
 */
const ReactEmbeddableRenderer = ({
  type,
  maybeId,
  getParentApi,
  panelProps,
  onAnyStateChange,
  onApiAvailable,
  hidePanelChrome
}) => {
  const cleanupFunction = (0, _react.useRef)(null);
  const phaseTracker = (0, _react.useRef)(new _phase_tracker.PhaseTracker());
  const componentPromise = (0, _react.useMemo)(() => {
    const uuid = maybeId !== null && maybeId !== void 0 ? maybeId : (0, _uuid.v4)();

    /**
     * Build the embeddable promise
     */
    return (async () => {
      const parentApi = getParentApi();
      const subscriptions = new _rxjs.Subscription();
      const buildEmbeddable = async () => {
        var _parentApi$getRuntime;
        const factory = await (0, _react_embeddable_registry.getReactEmbeddableFactory)(type);
        const serializedState = parentApi.getSerializedStateForChild(uuid);
        const lastSavedRuntimeState = serializedState ? await factory.deserializeState(serializedState) : {};

        // If the parent provides runtime state for the child (usually as a state backup or cache),
        // we merge it with the last saved runtime state.
        const partialRuntimeState = (0, _presentationContainers.apiHasRuntimeChildState)(parentApi) ? (_parentApi$getRuntime = parentApi.getRuntimeStateForChild(uuid)) !== null && _parentApi$getRuntime !== void 0 ? _parentApi$getRuntime : {} : {};
        const initialRuntimeState = {
          ...lastSavedRuntimeState,
          ...partialRuntimeState
        };
        const setApi = apiRegistration => {
          const hasLockedHoverActions$ = new _rxjs.BehaviorSubject(false);
          return {
            ...apiRegistration,
            uuid,
            phase$: phaseTracker.current.getPhase$(),
            parentApi,
            hasLockedHoverActions$,
            lockHoverActions: lock => {
              hasLockedHoverActions$.next(lock);
            },
            type: factory.type
          };
        };
        const buildApi = (apiRegistration, comparators) => {
          if (onAnyStateChange) {
            /**
             * To avoid unnecessary re-renders, only subscribe to the comparator publishing subjects if
             * an `onAnyStateChange` callback is provided
             */
            const comparatorDefinitions = Object.values(comparators);
            subscriptions.add((0, _rxjs.combineLatest)(comparatorDefinitions.map(comparator => comparator[0])).pipe((0, _rxjs.skip)(1), (0, _rxjs.debounceTime)(ON_STATE_CHANGE_DEBOUNCE), (0, _rxjs.map)(() => apiRegistration.serializeState())).subscribe(nextSerializedState => {
              onAnyStateChange(nextSerializedState);
            }));
          }
          const unsavedChanges = (0, _presentationContainers.initializeUnsavedChanges)(lastSavedRuntimeState, parentApi, comparators);
          const fullApi = setApi({
            ...apiRegistration,
            ...unsavedChanges.api
          });
          cleanupFunction.current = () => {
            subscriptions.unsubscribe();
            phaseTracker.current.cleanup();
            unsavedChanges.cleanup();
          };
          return fullApi;
        };
        const {
          api,
          Component
        } = await factory.buildEmbeddable(initialRuntimeState, buildApi, uuid, parentApi, setApi, lastSavedRuntimeState);
        phaseTracker.current.trackPhaseEvents(uuid, api);
        return {
          api,
          Component
        };
      };
      try {
        const {
          api,
          Component
        } = await buildEmbeddable();
        onApiAvailable === null || onApiAvailable === void 0 ? void 0 : onApiAvailable(api);
        return /*#__PURE__*/_react.default.forwardRef((_, ref) => {
          // expose the api into the imperative handle
          (0, _react.useImperativeHandle)(ref, () => api, []);
          return /*#__PURE__*/_react.default.createElement(Component, null);
        });
      } catch (e) {
        /**
         * critical error encountered when trying to build the api / embeddable;
         * since no API is available, create a dummy API that allows the panel to be deleted
         * */
        const errorApi = {
          uuid,
          blockingError$: new _rxjs.BehaviorSubject(e)
        };
        if ((0, _presentationContainers.apiIsPresentationContainer)(parentApi)) {
          errorApi.parentApi = parentApi;
        }
        return /*#__PURE__*/_react.default.forwardRef((_, ref) => {
          // expose the dummy error api into the imperative handle
          (0, _react.useImperativeHandle)(ref, () => errorApi, []);
          return null;
        });
      }
    })();
  },
  /**
   * Disabling exhaustive deps because we do not want to re-fetch the component
   * from the embeddable registry unless the type changes.
   */
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [type]);
  (0, _react.useEffect)(() => {
    return () => {
      var _cleanupFunction$curr;
      (_cleanupFunction$curr = cleanupFunction.current) === null || _cleanupFunction$curr === void 0 ? void 0 : _cleanupFunction$curr.call(cleanupFunction);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_public.PresentationPanel, (0, _extends2.default)({
    hidePanelChrome: hidePanelChrome
  }, panelProps, {
    Component: componentPromise
  }));
};
exports.ReactEmbeddableRenderer = ReactEmbeddableRenderer;