"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAddFromLibraryType = exports.getAddFromLibraryType = void 0;
exports.useAddFromLibraryTypes = useAddFromLibraryTypes;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registry = new Map();
const registerAddFromLibraryType = ({
  onAdd,
  savedObjectType,
  savedObjectName,
  getIconForSavedObject,
  getSavedObjectSubType,
  getTooltipForSavedObject
}) => {
  if (registry.has(savedObjectType)) {
    throw new Error(`Saved object type '${savedObjectType}' already exists in the 'Add from Library' registry.`);
  }
  registry.set(savedObjectType, {
    onAdd,
    savedObjectMetaData: {
      name: savedObjectName,
      type: savedObjectType,
      getIconForSavedObject,
      getTooltipForSavedObject,
      getSavedObjectSubType
    }
  });
};
exports.registerAddFromLibraryType = registerAddFromLibraryType;
function useAddFromLibraryTypes() {
  return (0, _react.useMemo)(() => {
    return [...registry.entries()].map(([type, registryItem]) => registryItem.savedObjectMetaData).sort((a, b) => a.type.localeCompare(b.type));
  }, []);
}
const getAddFromLibraryType = type => {
  return registry.get(type);
};
exports.getAddFromLibraryType = getAddFromLibraryType;