"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateKnowledgeBaseEntryRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _common_attributes = require("@kbn/elastic-assistant-common/impl/schemas/knowledge_base/entries/common_attributes.gen");
var _utils = require("../../utils");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateKnowledgeBaseEntryRoute = router => {
  router.versioned.put({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.UpdateKnowledgeBaseEntryRequestParams),
        body: (0, _common.buildRouteValidationWithZod)(_common_attributes.KnowledgeBaseEntryUpdateRouteProps)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _updateResponse$error, _updateResponse$error2;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const logger = ctx.elasticAssistant.logger;

      // Perform license, authenticated user and FF checks
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      logger.debug(() => `Updating KB Entry:\n${JSON.stringify(request.body)}`);
      const kbDataClient = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient();
      const updateResponse = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.updateKnowledgeBaseEntry({
        knowledgeBaseEntry: {
          ...request.body,
          id: request.params.id,
          ...(request.body.global ? {
            users: []
          } : {})
        },
        auditLogger: ctx.elasticAssistant.auditLogger,
        telemetry: ctx.elasticAssistant.telemetry
      }));
      if (updateResponse !== null && updateResponse !== void 0 && updateResponse.updatedEntry) {
        return response.ok({
          body: updateResponse === null || updateResponse === void 0 ? void 0 : updateResponse.updatedEntry
        });
      }
      return assistantResponse.error({
        body: (_updateResponse$error = updateResponse === null || updateResponse === void 0 ? void 0 : (_updateResponse$error2 = updateResponse.errors) === null || _updateResponse$error2 === void 0 ? void 0 : _updateResponse$error2[0].message) !== null && _updateResponse$error !== void 0 ? _updateResponse$error : `Knowledge Base Entry was not updated`,
        statusCode: 400
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.updateKnowledgeBaseEntryRoute = updateKnowledgeBaseEntryRoute;