"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteKnowledgeBaseEntryRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _crud_knowledge_base_entries_route = require("@kbn/elastic-assistant-common/impl/schemas/knowledge_base/entries/crud_knowledge_base_entries_route.gen");
var _utils = require("../../utils");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteKnowledgeBaseEntryRoute = router => {
  router.versioned.delete({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _common.buildRouteValidationWithZod)(_crud_knowledge_base_entries_route.DeleteKnowledgeBaseEntryRequestParams)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _deleteResponse$error, _deleteResponse$error2;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const logger = ctx.elasticAssistant.logger;

      // Perform license, authenticated user and FF checks
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      logger.debug(() => `Deleting KB Entry:\n${JSON.stringify(request.body)}`);
      const kbDataClient = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient();
      const deleteResponse = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.deleteKnowledgeBaseEntry({
        knowledgeBaseEntryId: request.params.id,
        auditLogger: ctx.elasticAssistant.auditLogger
      }));
      if (deleteResponse !== null && deleteResponse !== void 0 && deleteResponse.docsDeleted) {
        return response.ok({
          body: {
            id: deleteResponse === null || deleteResponse === void 0 ? void 0 : deleteResponse.docsDeleted[0]
          }
        });
      }
      return assistantResponse.error({
        body: (_deleteResponse$error = deleteResponse === null || deleteResponse === void 0 ? void 0 : (_deleteResponse$error2 = deleteResponse.errors) === null || _deleteResponse$error2 === void 0 ? void 0 : _deleteResponse$error2[0].message) !== null && _deleteResponse$error !== void 0 ? _deleteResponse$error : `Knowledge Base Entry was not deleted`,
        statusCode: 400
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteKnowledgeBaseEntryRoute = deleteKnowledgeBaseEntryRoute;