"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createKnowledgeBaseEntryRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _common_attributes = require("@kbn/elastic-assistant-common/impl/schemas/knowledge_base/entries/common_attributes.gen");
var _utils = require("../../utils");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createKnowledgeBaseEntryRoute = router => {
  router.versioned.post({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_common_attributes.KnowledgeBaseEntryCreateProps)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const logger = ctx.elasticAssistant.logger;

      // Perform license, authenticated user and FF checks
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const kbDataClient = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient();
      logger.debug(() => `Creating KB Entry:\n${JSON.stringify(request.body)}`);
      const createResponse = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.createKnowledgeBaseEntry({
        knowledgeBaseEntry: {
          ...request.body,
          ...(request.body.global ? {
            users: []
          } : {})
        },
        auditLogger: ctx.elasticAssistant.auditLogger,
        telemetry: ctx.elasticAssistant.telemetry
      }));
      if (createResponse == null) {
        return assistantResponse.error({
          body: `Knowledge Base Entry was not created`,
          statusCode: 400
        });
      }
      return response.ok({
        body: createResponse
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.createKnowledgeBaseEntryRoute = createKnowledgeBaseEntryRoute;