"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkActionAnonymizationFieldsRoute = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _bulk_crud_anonymization_fields_route = require("@kbn/elastic-assistant-common/impl/schemas/anonymization_fields/bulk_crud_anonymization_fields_route.gen");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _constants = require("../../../common/constants");
var _utils = require("../utils");
var _helpers = require("../../ai_assistant_data_clients/anonymization_fields/helpers");
var _helpers2 = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildBulkResponse = (response, {
  errors = [],
  updated = [],
  created = [],
  deleted = [],
  skipped = []
}) => {
  const numSucceeded = updated.length + created.length + deleted.length;
  const numSkipped = skipped.length;
  const numFailed = errors.length;
  const summary = {
    failed: numFailed,
    succeeded: numSucceeded,
    skipped: numSkipped,
    total: numSucceeded + numFailed + numSkipped
  };
  const results = {
    updated,
    created,
    deleted,
    skipped
  };
  if (numFailed > 0) {
    return response.custom({
      headers: {
        'content-type': 'application/json'
      },
      body: {
        message: summary.succeeded > 0 ? 'Bulk edit partially failed' : 'Bulk edit failed',
        attributes: {
          errors: errors.map(e => {
            var _e$status;
            return {
              status_code: (_e$status = e.status) !== null && _e$status !== void 0 ? _e$status : 500,
              anonymization_fields: [{
                id: e.document.id,
                name: ''
              }],
              message: e.message
            };
          }),
          results,
          summary
        }
      },
      statusCode: 500
    });
  }
  const responseBody = {
    success: true,
    anonymization_fields_count: summary.total,
    attributes: {
      results,
      summary
    }
  };
  return response.ok({
    body: responseBody
  });
};
const bulkActionAnonymizationFieldsRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_BULK_ACTION,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution-updateAIAssistantAnonymization']
      }
    },
    options: {
      timeout: {
        idleSocket: _moment.default.duration(15, 'minutes').asMilliseconds()
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_bulk_crud_anonymization_fields_route.PerformAnonymizationFieldsBulkActionRequestBody)
      }
    }
  }, async (context, request, response) => {
    var _body$update, _body$create, _body$delete$ids$leng, _body$delete, _body$delete$ids;
    const {
      body
    } = request;
    const assistantResponse = (0, _utils.buildResponse)(response);
    const operationsCount = (body !== null && body !== void 0 && body.update ? (_body$update = body.update) === null || _body$update === void 0 ? void 0 : _body$update.length : 0) + (body !== null && body !== void 0 && body.create ? (_body$create = body.create) === null || _body$create === void 0 ? void 0 : _body$create.length : 0) + (body !== null && body !== void 0 && body.delete ? (_body$delete$ids$leng = (_body$delete = body.delete) === null || _body$delete === void 0 ? void 0 : (_body$delete$ids = _body$delete.ids) === null || _body$delete$ids === void 0 ? void 0 : _body$delete$ids.length) !== null && _body$delete$ids$leng !== void 0 ? _body$delete$ids$leng : 0 : 0);
    if (operationsCount > _constants.ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE) {
      return assistantResponse.error({
        body: `More than ${_constants.ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE} ids sent for bulk edit action.`,
        statusCode: 400
      });
    }
    const abortController = new AbortController();

    // subscribing to completed$, because it handles both cases when request was completed and aborted.
    // when route is finished by timeout, aborted$ is not getting fired
    request.events.completed$.subscribe(() => abortController.abort());
    try {
      var _body$create2, _body$delete2, _body$update2;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      // Perform license and authenticated user checks
      const checkResponse = await (0, _helpers2.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const authenticatedUser = checkResponse.currentUser;
      const dataClient = await ctx.elasticAssistant.getAIAssistantAnonymizationFieldsDataClient();
      if (body.create && body.create.length > 0) {
        const result = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.findDocuments({
          perPage: 100,
          page: 1,
          filter: `(${body.create.map(c => `field:${c.field}`).join(' OR ')})`,
          fields: ['field']
        }));
        if ((result === null || result === void 0 ? void 0 : result.data) != null && result.total > 0) {
          return assistantResponse.error({
            statusCode: 409,
            body: `anonymization field: "${result.data.hits.hits.map(c => c._id).join(',')}" already exists`
          });
        }
      }
      const writer = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.getWriter());
      const createdAt = new Date().toISOString();
      const {
        errors,
        docs_created: docsCreated,
        docs_updated: docsUpdated,
        docs_deleted: docsDeleted
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      } = await writer.bulk({
        documentsToCreate: (_body$create2 = body.create) === null || _body$create2 === void 0 ? void 0 : _body$create2.map(doc => (0, _helpers.transformToCreateScheme)(authenticatedUser, createdAt, doc)),
        documentsToDelete: (_body$delete2 = body.delete) === null || _body$delete2 === void 0 ? void 0 : _body$delete2.ids,
        documentsToUpdate: (_body$update2 = body.update) === null || _body$update2 === void 0 ? void 0 : _body$update2.map(doc => (0, _helpers.transformToUpdateScheme)(authenticatedUser, createdAt, doc)),
        getUpdateScript: document => (0, _helpers.getUpdateScript)({
          anonymizationField: document,
          isPatch: true
        })
      });
      const created = docsCreated.length > 0 ? await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.findDocuments({
        page: 1,
        perPage: 1000,
        filter: docsCreated.map(c => `_id:${c}`).join(' OR ')
      })) : undefined;
      return buildBulkResponse(response, {
        updated: docsUpdated ? (0, _helpers.transformESToAnonymizationFields)(docsUpdated) : [],
        created: created !== null && created !== void 0 && created.data ? (0, _helpers.transformESSearchToAnonymizationFields)(created === null || created === void 0 ? void 0 : created.data) : [],
        deleted: docsDeleted !== null && docsDeleted !== void 0 ? docsDeleted : [],
        errors
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.bulkActionAnonymizationFieldsRoute = bulkActionAnonymizationFieldsRoute;