"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatPrompt = void 0;
var _prompts = require("@langchain/core/prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatPrompt = ({
  prompt,
  additionalPrompt
}) => _prompts.ChatPromptTemplate.fromMessages([['system', additionalPrompt ? `${prompt}\n\n${additionalPrompt}` : prompt], ['placeholder', '{knowledge_history}'], ['placeholder', '{chat_history}'], ['human', '{input}'], ['placeholder', '{agent_scratchpad}']]);
exports.formatPrompt = formatPrompt;