"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GENERATE_CHAT_TITLE_PROMPT = void 0;
exports.generateChatTitle = generateChatTitle;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("@langchain/core/prompts");
var _prompt = require("../../../../prompt");
var _constants = require("../constants");
var _local_prompt_object = require("../../../../prompt/local_prompt_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERATE_CHAT_TITLE_PROMPT = ({
  prompt,
  responseLanguage
}) => _prompts.ChatPromptTemplate.fromMessages([['system', `${prompt}\nPlease create the title in ${responseLanguage}.`], ['human', '{input}']]);
exports.GENERATE_CHAT_TITLE_PROMPT = GENERATE_CHAT_TITLE_PROMPT;
async function generateChatTitle({
  actionsClient,
  logger,
  savedObjectsClient,
  state,
  model
}) {
  try {
    logger.debug(() => `${_constants.NodeType.GENERATE_CHAT_TITLE}: Node state:\n${JSON.stringify(state, null, 2)}`);
    const outputParser = new _output_parsers.StringOutputParser();
    const prompt = await (0, _prompt.getPrompt)({
      actionsClient,
      connectorId: state.connectorId,
      promptId: _prompt.promptDictionary.chatTitle,
      promptGroupId: _local_prompt_object.promptGroupId.aiAssistant,
      provider: state.llmType,
      savedObjectsClient
    });
    const graph = GENERATE_CHAT_TITLE_PROMPT({
      prompt,
      responseLanguage: state.responseLanguage
    }).pipe(model).pipe(outputParser);
    const chatTitle = await graph.invoke({
      input: JSON.stringify(state.input, null, 2)
    });
    logger.debug(`chatTitle: ${chatTitle}`);
    return {
      chatTitle,
      lastNode: _constants.NodeType.GENERATE_CHAT_TITLE
    };
  } catch (e) {
    var _ref, _e$name;
    return {
      // generate a chat title if there is an error in order to complete the graph
      // limit title to 60 characters
      chatTitle: ((_ref = (_e$name = e.name) !== null && _e$name !== void 0 ? _e$name : e.message) !== null && _ref !== void 0 ? _ref : e.toString()).slice(0, 60),
      lastNode: _constants.NodeType.GENERATE_CHAT_TITLE
    };
  }
}