"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCombinedRefinePrompt = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a prompt that combines the initial query, a refine prompt, and partial results
 */
const getCombinedRefinePrompt = ({
  attackDiscoveryPrompt,
  combinedRefinements,
  continuePrompt,
  refinePrompt,
  unrefinedResults
}) => {
  const baseQuery = `${attackDiscoveryPrompt}

${refinePrompt}

"""
\`\`\`json
{
  "insights": ${JSON.stringify(unrefinedResults, null, 2)}
}
\`\`\`
"""

`;
  return (0, _fp.isEmpty)(combinedRefinements) ? baseQuery // no partial results yet
  : `${baseQuery}

${continuePrompt}

"""
${combinedRefinements}
"""

`;
};
exports.getCombinedRefinePrompt = getCombinedRefinePrompt;