---
title: "Vulnerability summary: Follina, CVE-2022-30190"
slug: "vulnerability-summary-follina"
date: "2023-01-19"
description: "Elastic is deploying a new malware signature to identify the use of the Follina vulnerability. Learn more in this post."
author:
  - slug: devon-kerr
image: "blog-security-detection-720x420.png"
category:
  - slug: security-research
  - slug: vulnerability-updates
---

On May 27, 2022, the nao_sec independent security research group shared a VirusTotal link to a weaponized Microsoft Office document revealing a previously unknown vulnerability in the Microsoft Support Diagnostic Tool (MSDT). This vulnerability is most likely to be exploited via phishing lure attachments and is triggered when a document is opened. Readers should expect this vulnerability to be adopted by threats of all kinds and be aware that it enables arbitrary code to be executed as outlined in Microsoft’s [<u>disclosure</u>](https://msrc-blog.microsoft.com/2022/05/30/guidance-for-cve-2022-30190-microsoft-support-diagnostic-tool-vulnerability/).

## Summary

Readers may [<u>recall</u>](https://www.elastic.co/blog/playing-defense-against-gamaredon-group) that template injection is an [<u>established</u>](https://attack.mitre.org/techniques/T1221/) technique enabling an attacker to remotely load malicious content when a document is opened by a relevant application. This vulnerability — dubbed “[<u>Follina</u>](https://doublepulsar.com/follina-a-microsoft-office-code-execution-vulnerability-1a47fce5629e)” — works in conjunction with template injection, specifically when the remote template uses the ms-msdt URI handler. Importantly, it does not require macros to be enabled. As in other cases of template injection, readers should be aware that remote objects may be heavily obfuscated.

Security teams should monitor msdt.exe as a child process of WINWORD.exe and other applications, paying particular attention to command line arguments and network activity attributed to that child process. Security teams may also consider monitoring network activity from all MS Office applications and their descendants as one way of generically identifying initial exploitation attempts via weaponized documents.

Elastic is deploying a new malware signature to identify the use of ms-msdt URIs. This signature will be distributed via the Elastic Endpoint. The team has also issued an update to the “[<u>Suspicious MS Office Child Process</u>](https://github.com/elastic/detection-rules/blob/main/rules/windows/initial_access_suspicious_ms_office_child_process.toml)” rule available via the [<u>detection-rules repository</u>](https://github.com/elastic/detection-rules), adding “msdt.exe” to the list of suspicious descendants and “Outlook.exe” to the list of relevant parent processes. The following query pertains to Elastic Endgame:

```
Network where process_name == “msdt.exe” and
descendant of  [process where process_name == “winword.exe” ]
| unique process_name, command_line
```

## References

Several organizations have released information and resources related to this vulnerability (non-exhaustive):

- Microsoft’s [<u>guidance</u>](https://msrc-blog.microsoft.com/2022/05/30/guidance-for-cve-2022-30190-microsoft-support-diagnostic-tool-vulnerability/), outlining one method of disabling the MSDT URL protocol
- Huntress has provided their [<u>analysis</u>](https://www.huntress.com/blog/microsoft-office-remote-code-execution-follina-msdt-bug) of the vulnerability with additional information about ms-msdt abuse Todyl has shared an [<u>Elastic query </u>](https://twitter.com/brent_murphy/status/1531322468228399104?t=yX_zDYE4ew6gA4am6a75Ug&s=09)pertaining to process events

Kevin Beaumont has provided a [<u>write-up</u>](https://doublepulsar.com/follina-a-microsoft-office-code-execution-vulnerability-1a47fce5629e) with historical and other details about potential implementations.
