---
title: "Unveiling malware behavior trends"
slug: "unveiling-malware-behavior-trends"
date: "2024-03-20"
subtitle: "Analyzing a Windows dataset of over 100,000 malicious files"
description: "An analysis of a diverse dataset of Windows malware extracted from more than 100,000 samples revealing insights into the most prevalent tactics, techniques, and procedures."
author:
  - slug: samir-bousseaden
image: "Security Labs Images 20.jpg"
category:
  - slug: security-research
---

## Preamble

When prioritizing detection engineering efforts, it's essential to understand the most prevalent tactics, techniques, and procedures (TTPs) observed in the wild. This knowledge helps defenders make informed decisions about the most effective strategies to implement - especially where to focus engineering efforts and finite resources.

To highlight these prevalent TTPs, we analyzed over [100,000 Windows malware samples](https://gist.github.com/Samirbous/eebeb8f776f7ab2d51cdd2ac05669dcf) extracted over several months from one of our dynamic malware analysis tools, [Detonate](https://www.elastic.co/security-labs/click-click-boom-automating-protections-testing-with-detonate). To generate this data and alerts, we leveraged Elastic Defend behavior (mapped to MITRE ATT&CK) and [memory threat detection](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html#memory-protection) rules. It should be noted that this dataset is not exhaustive, it may not represent the entire spectrum of malware behavior, and specifically does not include long-term or interactive activity.

Below an [ES|QL](https://www.elastic.co/blog/esql-elasticsearch-piped-query-language) query to summarize our dataset by file type:

![Dataset by extension - 20 unique file types](/assets/images/unveiling-malware-behavior-trends/image12.png)


## Tactics

Beginning with tactics, we aggregated the alerts generated by this corpus of malware samples and organized them according to the counts of [```process.entity_id```](https://www.elastic.co/guide/en/ecs/current/ecs-process.html#field-process-entity-id) and alerts. As depicted in the image below, the most frequent tactics included defense evasion, privilege escalation, execution, and persistence. Certain tactics commonly linked with post-exploitation activities, such as lateral movement, provided an anticipated lower prevalence because these actions are commonly manually driven by the threat actor after the initial implant is established vs. being automated by the malware in our dataset.

![Tactics by volume](/assets/images/unveiling-malware-behavior-trends/image9.png)


In the following sections, we will delve into each tactic and the techniques and sub-techniques of each that exerted the most influence.

### Defense Evasion

Defense Evasion involves methods employed by adversaries to avoid detection by security teams or capabilities. The foremost tactic detected was defense evasion, triggering 189 distinct detection rules (nearly 40% of our current Windows rules). The primary techniques noted are associated with [code injection](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1055%22&type=code), [defense tampering](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22Impair+Defenses%22&type=code), [masquerading](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22Masquerade+Task+or+Service%22&type=code), and [system binary proxy execution](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1218%22&type=code).

![Top observed defense evasion techniques](/assets/images/unveiling-malware-behavior-trends/image15.png)


When we pivot by sub-techniques, it becomes evident that certain advanced techniques such as [DLL side-loading](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22DLL+Side-Loading%22&type=code&p=1) and [Parent PID Spoofing](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts%20%22Parent%20PID%20Spoofing%22&type=code) have become increasingly popular, even among non-targeted malwares. Both are frequently linked with code injection and masquerading.

Furthermore, system binary proxies [```Rundll32```](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1218.011%22&type=code) and [```Regsvr32```](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1218.010%22&type=code) remain highly abused, with a notable rise in the utilization of malicious [MSI installers](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1218.007%22&type=code) for malware delivery. The practice of [masquerading](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22Masquerade+Task+or+Service%22&type=code) as legitimate system binaries, whether through renaming or process hollowing, remains prevalent as well, serving as a means to evade user suspicion.

![Top observed defense evasion sub-techniques](/assets/images/unveiling-malware-behavior-trends/image6.png)


Tampering with Windows Defender stands out as the most frequently observed defense evasion tactic, emphasizing the importance for defenders to acknowledge that adversaries will attempt to obscure their activities. 

Process Injection is prevalent across various malware families, whether they target legitimate system binaries remotely to blend in or employ self-injection (sometimes paired with DLL side-loading through a trusted binary). Furthermore, there is a noticeable uptick in the use of NTDLL unhooking to bypass security solutions reliant on user-mode APIs monitoring (Elastic Defend is not impacted).

![The most effective endpoint behavior rules for defense evasion](/assets/images/unveiling-malware-behavior-trends/image16.png)


From our shellcode alerts we can clearly see that self-injection is more prevalent than remote: 

![Shellcode alerts volume by infection target type (local vs remote)](/assets/images/unveiling-malware-behavior-trends/image7.png)


Almost 50 unique vendors’ binaries abused for DLL side-loading, of which Microsoft is the top choice: 

![DLL side-load by host process code signature subject name](/assets/images/unveiling-malware-behavior-trends/image19.png)


Defense evasion comprises various techniques and sub-techniques necessitating comprehensive coverage due to their frequent occurrence. For instance, apart from [memory threat protection](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html#memory-protection), [half](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts++name+%3D+%22Defense+Evasion%22&type=code) of our rules are specifically tailored to address this tactic.

### Privilege Escalation

This tactic consists of techniques that adversaries use to gain greater permissions on a system or network. The most commonly used techniques relate to [access token manipulation](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1134%22&type=code), execution through privileged [system services](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1543.003%22&type=code), and bypassing [User Account Control](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1548.002%22&type=code).

![Privilege escalation techniques observed in the dataset](/assets/images/unveiling-malware-behavior-trends/image10.png)


The most frequently observed sub-technique involved impersonation as the Trusted Installer service, which aligns closely with defense evasion and often precedes attempts to manipulate system-protected resources. 

Concerning User Account Control bypass, the primary method we observed was elevation by [mimicking trusted directories](https://medium.com/tenable-techblog/uac-bypass-by-mocking-trusted-directories-24a96675f6e), which is also related to DLL side-loading. Additionally, other methods like elevation via [extended startupinfo](https://github.com/decoder-it/psgetsystem) (elevated parent PID spoofing) are increasingly prevalent among commodity malware.

![Privilege escalation top observed sub-techniques](/assets/images/unveiling-malware-behavior-trends/image1.png)


As evident from the list below, there's a notable rise in the use of [vulnerable drivers](https://www.elastic.co/security-labs/stopping-vulnerable-driver-attacks) (BYOVD) to manipulate protected objects and acquire kernel mode execution privileges. 
 
![The most effective endpoint behavior rules for privilege escalation](/assets/images/unveiling-malware-behavior-trends/image2.png)


Below, you'll find a list of the most commonly exploited drivers triggered by our [YARA rules](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts%20vulndriver&type=code):

![Top triggered yara rules for vulnerable drivers detection](/assets/images/unveiling-malware-behavior-trends/image18.png)


### Execution

Execution encompasses methods that lead to running adversary-controlled code on a local or remote system. These techniques are frequently combined with methods from other tactics to accomplish broader objectives, such as network reconnaissance or data theft. 

The most common techniques observed here involved [Windows command and scripting languages](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22Command+and+Scripting+Interpreter%22+%5B%22windows%22%5D&type=code), with the proxying of execution via the [Windows Management Instrumentation](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1047%22&type=code) (WMI) interface closely trailing behind.

![Execution techniques observed in our dataset](/assets/images/unveiling-malware-behavior-trends/image21.png)


[Powershell](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1059.001%22&type=code) remains a preferred scripting language for malware execution chains, followed by [Javascript](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1059.007%22&type=code) and [VBscript](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1059.005%22&type=code). Multi-stage malware delivery routinely involves a combination of two or more scripting languages.

![Execution top observed sub-techniques](/assets/images/unveiling-malware-behavior-trends/image5.png)


Here is a list of the most frequently triggered endpoint behavior detections for this tactic:

![Frequently triggered execution detections](/assets/images/unveiling-malware-behavior-trends/image13.png)


Windows' default scripting languages remain the top preference for malware execution. However, there has been a slight uptick in the shift towards using other third-party scripting interpreters like Python, AutoIt, Java and Lua.

### Persistence

It's common for malware to install itself on an infected host. No surprises here: the most frequently observed persistence methods include [scheduled tasks](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1053.005%22&type=code), the [run key and startup folder](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1547.001%22&type=code), and [Windows services](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1543.003%22&type=code) (which typically require administrator privileges).

![Top observed sub-techniques for persistence](/assets/images/unveiling-malware-behavior-trends/image14.png)


The top three persistence sub-techniques depicted in the list below are also commonly encountered in regular software installations. Therefore, it's necessary to dissect them into multiple detections with additional suspicious signals to reduce false positives and enhance precision.

![Top triggered alerts for persistence](/assets/images/unveiling-malware-behavior-trends/image8.png)


### Initial Access

Considering the dataset's composition, initial access was associated with primarily macro-enabled documents and Windows shortcut objects. Although a significant portion of the detonated samples also involved other formats, such as ISO/VHD containers with MSI installers extensively utilized for delivery, their genuine malicious behavior typically manifests in areas such as defense evasion and persistence.

![Top sub-techniques for initial access](/assets/images/unveiling-malware-behavior-trends/image17.png)


The most frequently abused Microsoft-signed binaries originating from malicious Microsoft Office documents align closely with execution and defense evasion tactics, command and scripting interpreters, and system binary proxy execution.

![Top spawned child processes from malicious office documents](/assets/images/unveiling-malware-behavior-trends/image11.png)


Here is a list of the most frequently triggered detections for initial access, regarding [phishing attachments](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1566.001%22&type=code):

![Top triggered rules for initial access via malicious attachments](/assets/images/unveiling-malware-behavior-trends/image4.png)


### Credential Access

Credential access in malware is frequently linked to information stealers. The most targeted credentials are typically associated with [Windows Credential Manager](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1555.004%22&type=code) and [browser password](https://github.com/search?q=repo%3Aelastic%2Fprotections-artifacts+%22T1555.003%22&type=code) stores. Domain and system-protected credentials require elevated privileges and are more likely a feature of a subsequent stage.

![Top observed credential access sub-techniques](/assets/images/unveiling-malware-behavior-trends/image20.png)


Below a breakdown of the endpoint behavior detections that triggered the most on credentials access: 

![Frequently triggered credential access-related detection rules ](/assets/images/unveiling-malware-behavior-trends/image3.png)


The majority of credentials access behaviors resemble typical file access events. Therefore, it's essential to correlate and enrich them with additional signals to reduce false positives and enhance comprehension.

## Conclusion

Even though this small dataset of about [100,000 malware samples](https://gist.github.com/Samirbous/eebeb8f776f7ab2d51cdd2ac05669dcf) represents only a fraction of the possible malware in the wild right now, we can still derive important insights from it about the most common TTPs using our behavioral detections. Those insights help us make decisions about detection engineering priorities, and defenders should make that part of their strategies.