---
title: "Forecast and Recommendations: 2022 Elastic Global Threat Report"
slug: "forecast-and-recommendations-2022-elastic-global-threat-report"
date: "2022-11-30"
description: "With the release of our first Global Threat Report at Elastic, customers, partners, and the security community at large are able to identify many of the focus areas our team has had over the past 12 months."
author:
  - slug: santosh-krishnan
image: "gtr-blog-image-720x420.jpg"
category:
  - slug: reports
---

Today, we released our first-ever [Global Threat Report](https://www.elastic.co/explore/security-without-limits/global-threat-report) at Elastic. Now, customers, partners, and the security community at large will be able to identify many of the focus areas our team has had over the past 12 months. In addition to a technical perspective, this report also brings along a series of strategic recommendations for executives and security leaders alike: a summarized, accurate perspective of where we can expect to see adversaries move over the coming months.

Our hope is that threat researchers and the security industry as a whole will use this report to prepare for the next set of threats and campaigns. At Elastic, we are ensuring that our customers using the Elastic Security solution are best protected from these types of threats, including endpoint and cloud capabilities for automated protection.

This year, our report included six key forecasts and recommendations for strategists and practitioners to stay better informed of potential directions that threat actors may focus on in 2023 and beyond. Below, we summarize the first three of our forecasts. Further details on these and our other recommendations are available in our full, [downloadable report](https://www.elastic.co/explore/security-without-limits/global-threat-report) for 2022:

> Adversaries will continue to abuse built-in binary proxies to evade security instrumentation.&nbsp;
>
> The use of proven adversarial tactics remains a key area of focus for observed threat groups, and this year remains no different. Hostile groups leverage legitimate, native system binaries to load malicious software — evading many detection strategies used by modern enterprises.
>
> With this continued focus, Elastic Security has enhanced our deep visibility and pre-built protections, including numerous rules and signatures, alongside ML models to detect these threats faster and more effectively.

![](/assets/images/forecast-and-recommendations-2022-elastic-global-threat-report/blog-elastic-threat2022-1.jpg)

> LNK and ISO payloads will replace more conventional script and document payloads.
>
> Adversarial behavior focuses on finding easier, more efficient pathways for attack — and this year, it is no different. System defaults have forced threat groups to pivot their strategies to leverage LNK and ISO payloads over familiar scripts and documents we have observed in the past.
>
> LNK and ISO files are often used to smuggle malicious software into enterprises because most security technologies don't inspect them. Elastic Security has focused on building instrumentation into our products and platform, allowing us to determine the exact mechanisms used to better build a defense against these malicious acts.

![](/assets/images/forecast-and-recommendations-2022-elastic-global-threat-report/blog-elastic-threat2022-2.jpg)

> Valid IAM accounts will continue to be a target for adversaries.
>
> The early stages of many attacks focus on credential theft in all forms; however, IAM and administrative credentials often remain the area of focus for many adversarial groups looking to evade detection and avoid exploitation of services.&nbsp;
>
> Understanding standard account actions and user behaviors exhibited in environments is critical to defending them, and ensuring we have a comprehensive library of detections alongside integration capabilities within the stack has provided a strong foundation in detecting threats earlier.

![](/assets/images/forecast-and-recommendations-2022-elastic-global-threat-report/blog-elastic-threat2022-3.jpg)

This is just a small introduction to the findings found in the report. Far greater detail, recommendations, and source data are available in the [2022 Elastic Global Threat Report](https://www.elastic.co/explore/security-without-limits/global-threat-report).

Those looking to learn more about the threats we observed and the mechanisms adversarial groups leveraged over the last year can read far more detailed information in our full report — alongside many recommendations and findings we have leveraged to help shape the strategy used within the Elastic Security solution, and future feature roadmap.

Feel free to check out the full [2022 Elastic Global Threat Report](https://www.elastic.co/explore/security-without-limits/global-threat-report) here.
