"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Vector = exports.SharedResponseProps = exports.ResponseFields = exports.Metadata = exports.KnowledgeBaseResourceEnum = exports.KnowledgeBaseResource = exports.KnowledgeBaseEntryUpdateRouteProps = exports.KnowledgeBaseEntryUpdateProps = exports.KnowledgeBaseEntryResponse = exports.KnowledgeBaseEntryErrorSchema = exports.KnowledgeBaseEntryDeleteResponse = exports.KnowledgeBaseEntryCreateProps = exports.InputSchema = exports.IndexEntryUpdateFields = exports.IndexEntryType = exports.IndexEntryResponseFields = exports.IndexEntryRequiredFields = exports.IndexEntryOptionalFields = exports.IndexEntryCreateFields = exports.IndexEntry = exports.DocumentEntryUpdateFields = exports.DocumentEntryType = exports.DocumentEntryResponseFields = exports.DocumentEntryRequiredFields = exports.DocumentEntryOptionalFields = exports.DocumentEntryCreateFields = exports.DocumentEntry = exports.DeleteResponseFields = exports.BaseUpdateProps = exports.BaseResponseProps = exports.BaseRequiredFields = exports.BaseDefaultableFields = exports.BaseCreateProps = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Knowledge Base Attributes
 *   version: not applicable
 */

/**
 * Array of objects defining the input schema, allowing the LLM to extract structured data to be used in retrieval
 */

const InputSchema = exports.InputSchema = _zod.z.array(_zod.z.object({
  /**
   * Name of the field
   */
  fieldName: _zod.z.string(),
  /**
   * Type of the field
   */
  fieldType: _zod.z.string(),
  /**
   * Description of the field
   */
  description: _zod.z.string()
}));
const KnowledgeBaseEntryErrorSchema = exports.KnowledgeBaseEntryErrorSchema = _zod.z.object({
  statusCode: _zod.z.number(),
  error: _zod.z.string(),
  message: _zod.z.string()
}).strict();

/**
 * Knowledge Base resource name for grouping entries, e.g. 'security_labs', 'user', etc
 */

const KnowledgeBaseResource = exports.KnowledgeBaseResource = _zod.z.enum(['security_labs', 'user']);
const KnowledgeBaseResourceEnum = exports.KnowledgeBaseResourceEnum = KnowledgeBaseResource.enum;

/**
 * Metadata about a Knowledge Base Entry
 */

const Metadata = exports.Metadata = _zod.z.object({
  kbResource: KnowledgeBaseResource,
  /**
   * Source document name or filepath
   */
  source: _zod.z.string(),
  /**
   * Whether this resource should always be included
   */
  required: _zod.z.boolean()
});

/**
 * Object containing Knowledge Base Entry text embeddings and modelId used to create the embeddings
 */

const Vector = exports.Vector = _zod.z.object({
  /**
   * ID of the model used to create the embeddings
   */
  modelId: _zod.z.string(),
  /**
   * Tokens with their corresponding values
   */
  tokens: _zod.z.object({}).catchall(_zod.z.number())
});
const BaseRequiredFields = exports.BaseRequiredFields = _zod.z.object({
  /**
   * Name of the Knowledge Base Entry
   */
  name: _zod.z.string()
});
const BaseDefaultableFields = exports.BaseDefaultableFields = _zod.z.object({
  /**
   * Kibana Space, defaults to 'default' space
   */
  namespace: _zod.z.string().optional(),
  /**
   * Whether this Knowledge Base Entry is global, defaults to false
   */
  global: _zod.z.boolean().optional(),
  /**
   * Users who have access to the Knowledge Base Entry, defaults to current user. Empty array provides access to all users.
   */
  users: _zod.z.array(_common_attributes.User).optional()
});
const BaseCreateProps = exports.BaseCreateProps = BaseRequiredFields.merge(BaseDefaultableFields);
const BaseUpdateProps = exports.BaseUpdateProps = BaseCreateProps.partial().merge(_zod.z.object({
  id: _common_attributes.NonEmptyString
}));
const BaseResponseProps = exports.BaseResponseProps = BaseRequiredFields.merge(BaseDefaultableFields.required());
const ResponseFields = exports.ResponseFields = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * Time the Knowledge Base Entry was created
   */
  createdAt: _zod.z.string(),
  /**
   * User who created the Knowledge Base Entry
   */
  createdBy: _zod.z.string(),
  /**
   * Time the Knowledge Base Entry was last updated
   */
  updatedAt: _zod.z.string(),
  /**
   * User who last updated the Knowledge Base Entry
   */
  updatedBy: _zod.z.string()
});
const DeleteResponseFields = exports.DeleteResponseFields = _zod.z.object({
  id: _common_attributes.NonEmptyString
});
const SharedResponseProps = exports.SharedResponseProps = BaseResponseProps.merge(ResponseFields);
const DocumentEntryType = exports.DocumentEntryType = _zod.z.literal('document');
const DocumentEntryRequiredFields = exports.DocumentEntryRequiredFields = _zod.z.object({
  /**
   * Entry type
   */
  type: _zod.z.literal('document'),
  kbResource: KnowledgeBaseResource,
  /**
   * Source document name or filepath
   */
  source: _zod.z.string(),
  /**
   * Knowledge Base Entry content
   */
  text: _zod.z.string()
});
const DocumentEntryOptionalFields = exports.DocumentEntryOptionalFields = _zod.z.object({
  /**
   * Whether this resource should always be included, defaults to false
   */
  required: _zod.z.boolean().optional(),
  vector: Vector.optional()
});
const DocumentEntryCreateFields = exports.DocumentEntryCreateFields = BaseCreateProps.merge(DocumentEntryRequiredFields).merge(DocumentEntryOptionalFields);
const DocumentEntryUpdateFields = exports.DocumentEntryUpdateFields = BaseUpdateProps.merge(DocumentEntryCreateFields);
const DocumentEntryResponseFields = exports.DocumentEntryResponseFields = DocumentEntryRequiredFields.merge(DocumentEntryOptionalFields);
const DocumentEntry = exports.DocumentEntry = SharedResponseProps.merge(DocumentEntryResponseFields);
const IndexEntryType = exports.IndexEntryType = _zod.z.literal('index');
const IndexEntryRequiredFields = exports.IndexEntryRequiredFields = _zod.z.object({
  /**
   * Entry type
   */
  type: _zod.z.literal('index'),
  /**
   * Index or Data Stream to query for Knowledge Base content
   */
  index: _zod.z.string(),
  /**
   * Field to query for Knowledge Base content
   */
  field: _zod.z.string(),
  /**
   * Description for when this index or data stream should be queried for Knowledge Base content. Passed to the LLM as a tool description
   */
  description: _zod.z.string(),
  /**
   * Description of query field used to fetch Knowledge Base content. Passed to the LLM as part of the tool input schema
   */
  queryDescription: _zod.z.string()
});
const IndexEntryOptionalFields = exports.IndexEntryOptionalFields = _zod.z.object({
  inputSchema: InputSchema.optional(),
  /**
   * Fields to extract from the query result, defaults to all fields if not provided or empty
   */
  outputFields: _zod.z.array(_zod.z.string()).optional()
});
const IndexEntryCreateFields = exports.IndexEntryCreateFields = BaseCreateProps.merge(IndexEntryRequiredFields).merge(IndexEntryOptionalFields);
const IndexEntryUpdateFields = exports.IndexEntryUpdateFields = BaseUpdateProps.merge(IndexEntryCreateFields);
const IndexEntryResponseFields = exports.IndexEntryResponseFields = IndexEntryRequiredFields.merge(IndexEntryOptionalFields);
const IndexEntry = exports.IndexEntry = SharedResponseProps.merge(IndexEntryResponseFields);
const KnowledgeBaseEntryCreateProps = exports.KnowledgeBaseEntryCreateProps = _zod.z.discriminatedUnion('type', [DocumentEntryCreateFields, IndexEntryCreateFields]);
const KnowledgeBaseEntryUpdateProps = exports.KnowledgeBaseEntryUpdateProps = _zod.z.discriminatedUnion('type', [DocumentEntryUpdateFields, IndexEntryUpdateFields]);
const KnowledgeBaseEntryUpdateRouteProps = exports.KnowledgeBaseEntryUpdateRouteProps = _zod.z.discriminatedUnion('type', [DocumentEntryCreateFields, IndexEntryCreateFields]);
const KnowledgeBaseEntryResponse = exports.KnowledgeBaseEntryResponse = _zod.z.discriminatedUnion('type', [DocumentEntry, IndexEntry]);
const KnowledgeBaseEntryDeleteResponse = exports.KnowledgeBaseEntryDeleteResponse = DeleteResponseFields;