"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformKnowledgeBaseEntryBulkActionResponse = exports.PerformKnowledgeBaseEntryBulkActionRequestBody = exports.NormalizedKnowledgeBaseEntryError = exports.KnowledgeBaseEntryDetailsInError = exports.KnowledgeBaseEntryBulkCrudActionSummary = exports.KnowledgeBaseEntryBulkCrudActionResults = exports.KnowledgeBaseEntryBulkCrudActionResponse = exports.KnowledgeBaseEntryBulkActionSkipResult = exports.KnowledgeBaseEntryBulkActionSkipReason = exports.KnowledgeBaseEntryBulkActionBase = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("./common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Knowledge Base Actions API endpoint
 *   version: 2023-10-31
 */

const KnowledgeBaseEntryBulkActionSkipReason = exports.KnowledgeBaseEntryBulkActionSkipReason = _zod.z.literal('KNOWLEDGE_BASE_ENTRY_NOT_MODIFIED');
const KnowledgeBaseEntryBulkActionSkipResult = exports.KnowledgeBaseEntryBulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: KnowledgeBaseEntryBulkActionSkipReason
});
const KnowledgeBaseEntryDetailsInError = exports.KnowledgeBaseEntryDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
const NormalizedKnowledgeBaseEntryError = exports.NormalizedKnowledgeBaseEntryError = _zod.z.object({
  message: _zod.z.string(),
  statusCode: _zod.z.number().int(),
  err_code: _zod.z.string().optional(),
  knowledgeBaseEntries: _zod.z.array(KnowledgeBaseEntryDetailsInError)
});
const KnowledgeBaseEntryBulkCrudActionResults = exports.KnowledgeBaseEntryBulkCrudActionResults = _zod.z.object({
  updated: _zod.z.array(_common_attributes.KnowledgeBaseEntryResponse),
  created: _zod.z.array(_common_attributes.KnowledgeBaseEntryResponse),
  deleted: _zod.z.array(_zod.z.string()),
  skipped: _zod.z.array(KnowledgeBaseEntryBulkActionSkipResult)
});
const KnowledgeBaseEntryBulkCrudActionSummary = exports.KnowledgeBaseEntryBulkCrudActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const KnowledgeBaseEntryBulkCrudActionResponse = exports.KnowledgeBaseEntryBulkCrudActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  statusCode: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  knowledgeBaseEntriesCount: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: KnowledgeBaseEntryBulkCrudActionResults,
    summary: KnowledgeBaseEntryBulkCrudActionSummary,
    errors: _zod.z.array(NormalizedKnowledgeBaseEntryError).optional()
  })
});
const KnowledgeBaseEntryBulkActionBase = exports.KnowledgeBaseEntryBulkActionBase = _zod.z.object({
  /**
   * Query to filter Knowledge Base Entries
   */
  query: _zod.z.string().optional(),
  /**
   * Array of Knowledge base Entry IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const PerformKnowledgeBaseEntryBulkActionRequestBody = exports.PerformKnowledgeBaseEntryBulkActionRequestBody = _zod.z.object({
  delete: KnowledgeBaseEntryBulkActionBase.optional(),
  create: _zod.z.array(_common_attributes.KnowledgeBaseEntryCreateProps).optional(),
  update: _zod.z.array(_common_attributes.KnowledgeBaseEntryUpdateProps).optional()
});
const PerformKnowledgeBaseEntryBulkActionResponse = exports.PerformKnowledgeBaseEntryBulkActionResponse = KnowledgeBaseEntryBulkCrudActionResponse;