"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefendInsightsUpdateProps = exports.DefendInsightsResponse = exports.DefendInsights = exports.DefendInsightUpdateProps = exports.DefendInsightTypeEnum = exports.DefendInsightType = exports.DefendInsightStatusEnum = exports.DefendInsightStatus = exports.DefendInsightGenerationInterval = exports.DefendInsightEvent = exports.DefendInsightCreateProps = exports.DefendInsight = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
var _common_attributes2 = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Defend Insights Attributes
 *   version: not applicable
 */

/**
 * A Defend insight event
 */

const DefendInsightEvent = exports.DefendInsightEvent = _zod.z.object({
  /**
   * The event's ID
   */
  id: _zod.z.string(),
  /**
   * The endpoint's ID
   */
  endpointId: _zod.z.string(),
  /**
   * The value of the event
   */
  value: _zod.z.string()
});

/**
 * The insight type (ie. incompatible_antivirus)
 */

const DefendInsightType = exports.DefendInsightType = _zod.z.enum(['incompatible_antivirus', 'noisy_process_tree']);
const DefendInsightTypeEnum = exports.DefendInsightTypeEnum = DefendInsightType.enum;

/**
 * A Defend insight generated from endpoint events
 */

const DefendInsight = exports.DefendInsight = _zod.z.object({
  /**
   * The group category of the events (ie. Windows Defender)
   */
  group: _zod.z.string(),
  /**
   * An array of event objects
   */
  events: _zod.z.array(DefendInsightEvent).optional()
});

/**
 * Array of Defend insights
 */

const DefendInsights = exports.DefendInsights = _zod.z.array(DefendInsight);

/**
 * The status of the Defend insight.
 */

const DefendInsightStatus = exports.DefendInsightStatus = _zod.z.enum(['running', 'succeeded', 'failed', 'canceled']);
const DefendInsightStatusEnum = exports.DefendInsightStatusEnum = DefendInsightStatus.enum;

/**
 * Run durations for the Defend insight
 */

const DefendInsightGenerationInterval = exports.DefendInsightGenerationInterval = _zod.z.object({
  /**
   * The time the Defend insight was generated
   */
  date: _zod.z.string(),
  /**
   * The duration of the Defend insight generation
   */
  durationMs: _zod.z.number().int()
});
const DefendInsightsResponse = exports.DefendInsightsResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  timestamp: _common_attributes.NonEmptyString.optional(),
  /**
   * The last time the Defend insight was updated.
   */
  updatedAt: _zod.z.string(),
  /**
   * The last time the Defend insight was viewed in the browser.
   */
  lastViewedAt: _zod.z.string(),
  /**
   * The number of events in the context.
   */
  eventsContextCount: _zod.z.number().int().optional(),
  /**
   * The time the Defend insight was created.
   */
  createdAt: _zod.z.string(),
  replacements: _common_attributes2.Replacements.optional(),
  users: _zod.z.array(_common_attributes.User),
  /**
   * The status of the Defend insight.
   */
  status: DefendInsightStatus,
  endpointIds: _zod.z.array(_common_attributes.NonEmptyString),
  insightType: DefendInsightType,
  /**
   * The Defend insights.
   */
  insights: DefendInsights,
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig,
  /**
   * Kibana space
   */
  namespace: _zod.z.string(),
  /**
   * The backing index required for update requests.
   */
  backingIndex: _zod.z.string(),
  /**
   * The most 5 recent generation intervals
   */
  generationIntervals: _zod.z.array(DefendInsightGenerationInterval),
  /**
   * The average generation interval in milliseconds
   */
  averageIntervalMs: _zod.z.number().int(),
  /**
   * The reason for a status of failed.
   */
  failureReason: _zod.z.string().optional()
});
const DefendInsightUpdateProps = exports.DefendInsightUpdateProps = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig.optional(),
  /**
   * The number of events in the context.
   */
  eventsContextCount: _zod.z.number().int().optional(),
  /**
   * The Defend insights.
   */
  insights: DefendInsights.optional(),
  /**
   * The status of the Defend insight.
   */
  status: DefendInsightStatus.optional(),
  replacements: _common_attributes2.Replacements.optional(),
  /**
   * The most 5 recent generation intervals
   */
  generationIntervals: _zod.z.array(DefendInsightGenerationInterval).optional(),
  /**
   * The backing index required for update requests.
   */
  backingIndex: _zod.z.string(),
  /**
   * The reason for a status of failed.
   */
  failureReason: _zod.z.string().optional(),
  /**
   * The last time the Defend insight was viewed in the browser.
   */
  lastViewedAt: _zod.z.string().optional()
});
const DefendInsightsUpdateProps = exports.DefendInsightsUpdateProps = _zod.z.array(DefendInsightUpdateProps);
const DefendInsightCreateProps = exports.DefendInsightCreateProps = _zod.z.object({
  /**
   * The Defend insight id.
   */
  id: _zod.z.string().optional(),
  /**
   * The status of the Defend insight.
   */
  status: DefendInsightStatus,
  /**
   * The number of events in the context.
   */
  eventsContextCount: _zod.z.number().int().optional(),
  endpointIds: _zod.z.array(_common_attributes.NonEmptyString),
  insightType: DefendInsightType,
  /**
   * The Defend insights.
   */
  insights: DefendInsights,
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig,
  replacements: _common_attributes2.Replacements.optional()
});