"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootContext = exports.MessageData = exports.ChatMessageRoleEnum = exports.ChatMessageRole = exports.ChatMessage = exports.ChatCompleteRequestBody = exports.ChatCompleteProps = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Chat Complete API endpoint
 *   version: 2023-10-31
 */

const RootContext = exports.RootContext = _zod.z.literal('security');

/**
 * Message role.
 */

const ChatMessageRole = exports.ChatMessageRole = _zod.z.enum(['system', 'user', 'assistant']);
const ChatMessageRoleEnum = exports.ChatMessageRoleEnum = ChatMessageRole.enum;
const MessageData = exports.MessageData = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * AI assistant message.
 */

const ChatMessage = exports.ChatMessage = _zod.z.object({
  /**
   * Message content.
   */
  content: _zod.z.string().optional(),
  /**
   * Message role.
   */
  role: ChatMessageRole,
  /**
   * ECS object to attach to the context of the message.
   */
  data: MessageData.optional(),
  fields_to_anonymize: _zod.z.array(_zod.z.string()).optional()
});
const ChatCompleteProps = exports.ChatCompleteProps = _zod.z.object({
  conversationId: _common_attributes.NonEmptyString.optional(),
  promptId: _zod.z.string().optional(),
  isStream: _zod.z.boolean().optional(),
  responseLanguage: _zod.z.string().optional(),
  langSmithProject: _zod.z.string().optional(),
  langSmithApiKey: _zod.z.string().optional(),
  connectorId: _zod.z.string(),
  model: _zod.z.string().optional(),
  persist: _zod.z.boolean(),
  messages: _zod.z.array(ChatMessage)
});
const ChatCompleteRequestBody = exports.ChatCompleteRequestBody = ChatCompleteProps;