"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformAnonymizationFieldsBulkActionResponse = exports.PerformAnonymizationFieldsBulkActionRequestBody = exports.NormalizedAnonymizationFieldError = exports.BulkCrudActionSummary = exports.BulkActionBase = exports.AnonymizationFieldsBulkCrudActionResults = exports.AnonymizationFieldsBulkCrudActionResponse = exports.AnonymizationFieldsBulkActionSkipResult = exports.AnonymizationFieldsBulkActionSkipReason = exports.AnonymizationFieldUpdateProps = exports.AnonymizationFieldResponse = exports.AnonymizationFieldDetailsInError = exports.AnonymizationFieldCreateProps = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Anonymization Fields Actions API endpoint
 *   version: 2023-10-31
 */

const AnonymizationFieldsBulkActionSkipReason = exports.AnonymizationFieldsBulkActionSkipReason = _zod.z.literal('ANONYMIZATION_FIELD_NOT_MODIFIED');
const AnonymizationFieldsBulkActionSkipResult = exports.AnonymizationFieldsBulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: AnonymizationFieldsBulkActionSkipReason
});
const AnonymizationFieldDetailsInError = exports.AnonymizationFieldDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
const NormalizedAnonymizationFieldError = exports.NormalizedAnonymizationFieldError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: _zod.z.string().optional(),
  anonymization_fields: _zod.z.array(AnonymizationFieldDetailsInError)
});
const AnonymizationFieldResponse = exports.AnonymizationFieldResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  timestamp: _common_attributes.NonEmptyString.optional(),
  field: _zod.z.string(),
  allowed: _zod.z.boolean().optional(),
  anonymized: _zod.z.boolean().optional(),
  updatedAt: _zod.z.string().optional(),
  updatedBy: _zod.z.string().optional(),
  createdAt: _zod.z.string().optional(),
  createdBy: _zod.z.string().optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string().optional()
});
const AnonymizationFieldsBulkCrudActionResults = exports.AnonymizationFieldsBulkCrudActionResults = _zod.z.object({
  updated: _zod.z.array(AnonymizationFieldResponse),
  created: _zod.z.array(AnonymizationFieldResponse),
  deleted: _zod.z.array(_zod.z.string()),
  skipped: _zod.z.array(AnonymizationFieldsBulkActionSkipResult)
});
const BulkCrudActionSummary = exports.BulkCrudActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const AnonymizationFieldsBulkCrudActionResponse = exports.AnonymizationFieldsBulkCrudActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  anonymization_fields_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: AnonymizationFieldsBulkCrudActionResults,
    summary: BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedAnonymizationFieldError).optional()
  })
});
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter anonymization fields
   */
  query: _zod.z.string().optional(),
  /**
   * Array of anonymization fields IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const AnonymizationFieldCreateProps = exports.AnonymizationFieldCreateProps = _zod.z.object({
  field: _zod.z.string(),
  allowed: _zod.z.boolean().optional(),
  anonymized: _zod.z.boolean().optional()
});
const AnonymizationFieldUpdateProps = exports.AnonymizationFieldUpdateProps = _zod.z.object({
  id: _zod.z.string(),
  allowed: _zod.z.boolean().optional(),
  anonymized: _zod.z.boolean().optional()
});
const PerformAnonymizationFieldsBulkActionRequestBody = exports.PerformAnonymizationFieldsBulkActionRequestBody = _zod.z.object({
  delete: BulkActionBase.optional(),
  create: _zod.z.array(AnonymizationFieldCreateProps).optional(),
  update: _zod.z.array(AnonymizationFieldUpdateProps).optional()
});
const PerformAnonymizationFieldsBulkActionResponse = exports.PerformAnonymizationFieldsBulkActionResponse = AnonymizationFieldsBulkCrudActionResponse;