"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageReady = void 0;
var _react = require("react");
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const usePageReady = state => {
  const {
    onPageReady
  } = (0, _.usePerformanceContext)();
  const [isReported, setIsReported] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (state.isReady && !isReported) {
      onPageReady({
        customMetrics: state.customMetrics,
        meta: state.meta
      });
      setIsReported(true);
    }
  }, [isReported, onPageReady, state.customMetrics, state.isReady, state.meta]);
};
exports.usePageReady = usePageReady;