"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExampleDataSourceProfileProvider = void 0;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _data_sources = require("../../../../../common/data_sources");
var _profiles = require("../../../profiles");
var _example_context = require("../example_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createExampleDataSourceProfileProvider = () => ({
  profileId: 'example-data-source-profile',
  isExperimental: true,
  profile: {
    getCellRenderers: prev => params => ({
      ...prev(params),
      'log.level': props => {
        const level = (0, _discoverUtils.getFieldValue)(props.row, 'log.level');
        if (!level) {
          return /*#__PURE__*/_react.default.createElement("span", {
            css: ({
              euiTheme
            }) => ({
              color: euiTheme.colors.textSubdued
            }),
            "data-test-subj": "exampleDataSourceProfileLogLevelEmpty"
          }, "(None)");
        }
        const levelMap = {
          info: 'primary',
          debug: 'default',
          error: 'danger'
        };
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: levelMap[level],
          title: level,
          "data-test-subj": "exampleDataSourceProfileLogLevel"
        }, (0, _lodash.capitalize)(level));
      },
      message: function Message(props) {
        const {
          currentMessage,
          setCurrentMessage
        } = (0, _example_context.useExampleContext)();
        const message = (0, _discoverUtils.getFieldValue)(props.row, 'message');
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => setCurrentMessage(message),
          css: {
            fontWeight: currentMessage === message ? 'bold' : undefined
          },
          "data-test-subj": "exampleDataSourceProfileMessage"
        }, message);
      }
    }),
    getDocViewer: (prev, {
      context
    }) => params => {
      const recordId = params.record.id;
      const prevValue = prev(params);
      return {
        title: `Record #${recordId}`,
        docViewsRegistry: registry => {
          registry.add({
            id: 'doc_view_example',
            title: 'Example',
            order: 0,
            component: () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
              color: "transparent",
              hasShadow: false
            }, /*#__PURE__*/_react.default.createElement("div", {
              "data-test-subj": "exampleDataSourceProfileDocView"
            }, "Example Doc View"), /*#__PURE__*/_react.default.createElement("pre", {
              "data-test-subj": "exampleDataSourceProfileDocViewRecord"
            }, context.formatRecord(params.record.flattened)))
          });
          return prevValue.docViewsRegistry(registry);
        }
      };
    },
    /**
     * The `getAppMenu` extension point gives access to AppMenuRegistry with methods registerCustomAction and registerCustomActionUnderSubmenu.
     * The extension also provides the essential params like current dataView, adHocDataViews etc when defining a custom action implementation.
     * And it supports opening custom flyouts and any other modals on the click.
     * `getAppMenu` can be configured in both root and data source profiles.
     * @param prev
     */
    getAppMenu: prev => params => {
      const prevValue = prev(params);

      // This is what is available via params:
      // const { dataView, services, isEsqlMode, adHocDataViews, onUpdateAdHocDataViews } = params;

      return {
        appMenuRegistry: registry => {
          // Note: Only 2 custom actions are allowed to be rendered in the app menu. The rest will be ignored.

          // Can be a on-click action, link or a submenu with an array of actions and horizontal rules
          registry.registerCustomAction({
            id: 'example-custom-action',
            type: _discoverUtils.AppMenuActionType.custom,
            controlProps: {
              label: 'Custom action',
              testId: 'example-custom-action',
              onClick: ({
                onFinishAction
              }) => {
                alert('Example Custom action clicked');
                onFinishAction(); // This allows to return focus back to the app menu DOM node
              }
            }
            // In case of a submenu, you can add actions to it under `actions`
            // actions: [
            //   {
            //     id: 'example-custom-action-1-1',
            //     type: AppMenuActionType.custom,
            //     controlProps: {
            //       label: 'Custom action',
            //       onClick: ({ onFinishAction }) => {
            //         alert('Example Custom action clicked');
            //         onFinishAction();
            //       },
            //     },
            //   },
            //   {
            //     id: 'example-custom-action-1-2',
            //     type: AppMenuActionType.submenuHorizontalRule
            //   },
            //   ...
            // ],
          });

          // This example shows how to add a custom action under the Alerts submenu
          registry.registerCustomActionUnderSubmenu(_discoverUtils.AppMenuActionId.alerts, {
            // It's also possible to override the submenu actions by using the same id
            // as `AppMenuActionId.createRule` or `AppMenuActionId.manageRulesAndConnectors`
            id: 'example-custom-action4',
            type: _discoverUtils.AppMenuActionType.custom,
            order: 101,
            controlProps: {
              label: 'Create SLO (Custom action)',
              iconType: 'visGauge',
              testId: 'example-custom-action-under-alerts',
              onClick: ({
                onFinishAction
              }) => {
                // This is an example of a custom action that opens a flyout or any other custom modal.
                // To do so, simply return a React element and call onFinishAction when you're done.
                return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
                  onClose: onFinishAction
                }, /*#__PURE__*/_react.default.createElement("div", null, "Example custom action clicked"));
              }
            }
          });

          // This submenu was defined in the root profile example_root_pofile/profile.tsx
          // And we can still add actions to it from the data source profile here.
          registry.registerCustomActionUnderSubmenu('example-custom-root-submenu', {
            id: 'example-custom-action5',
            type: _discoverUtils.AppMenuActionType.custom,
            controlProps: {
              label: 'Custom action (from Data Source profile)',
              onClick: ({
                onFinishAction
              }) => {
                alert('Example Data source action under root submenu clicked');
                onFinishAction();
              }
            }
          });
          return prevValue.appMenuRegistry(registry);
        }
      };
    },
    getRowAdditionalLeadingControls: prev => params => {
      const additionalControls = prev(params) || [];
      return [...additionalControls, ...['visBarVerticalStacked', 'heart', 'inspect'].map((iconType, index) => ({
        id: `exampleControl_${iconType}`,
        headerAriaLabel: `Example Row Control ${iconType}`,
        renderControl: (Control, rowProps) => {
          return /*#__PURE__*/_react.default.createElement(Control, {
            "data-test-subj": `exampleLogsControl_${iconType}`,
            label: `Example ${iconType}`,
            tooltipContent: `Example ${iconType}`,
            iconType: iconType,
            onClick: () => {
              alert(`Example "${iconType}" control clicked. Row index: ${rowProps.rowIndex}`);
            }
          });
        }
      }))];
    },
    getDefaultAppState: () => () => ({
      breakdownField: 'log.level',
      columns: [{
        name: '@timestamp',
        width: 212
      }, {
        name: 'log.level',
        width: 150
      }, {
        name: 'message'
      }],
      rowHeight: 5
    }),
    getAdditionalCellActions: prev => () => [...prev(), {
      id: 'example-data-source-action',
      getDisplayName: () => 'Example data source action',
      getIconType: () => 'plus',
      execute: () => {
        alert('Example data source action executed');
      }
    }, {
      id: 'another-example-data-source-action',
      getDisplayName: () => 'Another example data source action',
      getIconType: () => 'minus',
      execute: () => {
        alert('Another example data source action executed');
      },
      isCompatible: ({
        field
      }) => field.name !== 'message'
    }]
  },
  resolve: params => {
    let indexPattern;
    if ((0, _data_sources.isDataSourceType)(params.dataSource, _data_sources.DataSourceType.Esql)) {
      if (!(0, _esQuery.isOfAggregateQueryType)(params.query)) {
        return {
          isMatch: false
        };
      }
      indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(params.query.esql);
    } else if ((0, _data_sources.isDataSourceType)(params.dataSource, _data_sources.DataSourceType.DataView) && params.dataView) {
      indexPattern = params.dataView.getIndexPattern();
    }
    if (indexPattern !== 'my-example-logs') {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Logs,
        formatRecord: record => JSON.stringify(record, null, 2)
      }
    };
  }
});
exports.createExampleDataSourceProfileProvider = createExampleDataSourceProfileProvider;