"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfiles = void 0;
var _react = require("react");
var _use_discover_services = require("../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook to retreive the resolved profiles
 * @param options Profiles options
 * @returns The resolved profiles
 */
const useProfiles = ({
  record
} = {}) => {
  const {
    profilesManager
  } = (0, _use_discover_services.useDiscoverServices)();
  const [profiles, setProfiles] = (0, _react.useState)(() => profilesManager.getProfiles({
    record
  }));
  const profiles$ = (0, _react.useMemo)(() => profilesManager.getProfiles$({
    record
  }), [profilesManager, record]);
  (0, _react.useEffect)(() => {
    const subscription = profiles$.subscribe(newProfiles => {
      setProfiles(currentProfiles => {
        return currentProfiles.every((profile, i) => profile === newProfiles[i]) ? currentProfiles : newProfiles;
      });
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [profiles$]);
  return profiles;
};
exports.useProfiles = useProfiles;