"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlTracking = useUrlTracking;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _use_discover_services = require("../../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Enable/disable kbn url tracking (That's the URL used when selecting Discover in the side menu)
 */
function useUrlTracking(stateContainer) {
  const {
    savedSearchState,
    internalState
  } = stateContainer;
  const {
    urlTracker
  } = (0, _use_discover_services.useDiscoverServices)();
  (0, _react.useEffect)(() => {
    const subscription = savedSearchState.getCurrent$().subscribe(savedSearch => {
      const dataView = savedSearch.searchSource.getField('index');
      if (!(dataView !== null && dataView !== void 0 && dataView.id)) {
        return;
      }
      const dataViewSupportsTracking =
      // Disable for ad hoc data views, since they can't be restored after a page refresh
      dataView.isPersisted() ||
      // Unless it's a default profile data view, which can be restored on refresh
      internalState.get().defaultProfileAdHocDataViewIds.includes(dataView.id) ||
      // Or we're in ES|QL mode, in which case we don't care about the data view
      (0, _esQuery.isOfAggregateQueryType)(savedSearch.searchSource.getField('query'));
      const trackingEnabled = dataViewSupportsTracking || Boolean(savedSearch.id);
      urlTracker.setTrackingEnabled(trackingEnabled);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [internalState, savedSearchState, urlTracker]);
}