"use strict";

var _scout = require("@kbn/scout");
var _fixtures = require("../fixtures");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

_fixtures.spaceTest.describe('Discover app - value suggestions non-time based', {
  tag: ['@ess', '@svlSearch', '@svlOblt']
},
// TODO: Update to use an ES archive with an index accessible to 'viewer'
// for running this test against the Security serverless project.
() => {
  _fixtures.spaceTest.beforeAll(async ({
    scoutSpace
  }) => {
    await scoutSpace.savedObjects.load(_fixtures.testData.KBN_ARCHIVES.NO_TIME_FIELD);
    await scoutSpace.uiSettings.setDefaultIndex(_fixtures.testData.DATA_VIEW_NAME.NO_TIME_FIELD);
  });
  _fixtures.spaceTest.beforeEach(async ({
    browserAuth,
    pageObjects
  }) => {
    await browserAuth.loginAsViewer();
    await pageObjects.discover.goto();
  });
  _fixtures.spaceTest.afterAll(async ({
    scoutSpace
  }) => {
    await scoutSpace.uiSettings.unset('defaultIndex');
    await scoutSpace.savedObjects.cleanStandardList();
  });
  (0, _fixtures.spaceTest)('shows all auto-suggest options for a filter in discover context app', async ({
    page
  }) => {
    await page.testSubj.fill('queryInput', 'type.keyword : ');
    await (0, _scout.expect)(page.testSubj.locator('autoCompleteSuggestionText'), _fixtures.assertionMessages.QUERY_BAR_VALIDATION.SUGGESTIONS_COUNT).toHaveCount(1);
    const actualSuggestions = await page.testSubj.locator('autoCompleteSuggestionText').allTextContents();
    (0, _scout.expect)(actualSuggestions.join(',')).toContain('"apache"');
  });
});