"use strict";

var _scout = require("@kbn/scout");
var _fixtures = require("../fixtures");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

(0, _scout.globalSetupHook)('Ingest data to Elasticsearch', async ({
  esArchiver,
  log
}) => {
  // add archives to load, if needed
  const archives = [_fixtures.testData.ES_ARCHIVES.LOGSTASH, _fixtures.testData.ES_ARCHIVES.NO_TIME_FIELD, _fixtures.testData.ES_ARCHIVES.ECOMMERCE];
  log.debug('[setup] loading test data (only if indexes do not exist)...');
  for (const archive of archives) {
    await esArchiver.loadIfNeeded(archive);
  }
});