"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrendDocsChart = TrendDocsChart;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/embeddable-plugin/common");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _translations = require("../../../../../common/translations");
var _utils = require("../../../../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_HEIGHT = 180;
const DISABLED_ACTIONS = ['ACTION_CUSTOMIZE_PANEL', 'ACTION_CONFIGURE_IN_LENS', 'ACTION_OPEN_IN_DISCOVER', 'create-ml-ad-job-action'];
function TrendDocsChart({
  attributes,
  isChartLoading,
  onChartLoading,
  extraActions,
  timeRange,
  lastReloadTime,
  onTimeRangeChange
}) {
  const {
    services: {
      lens
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const handleBrushEnd = (0, _react.useCallback)(({
    range: [start, end]
  }) => {
    onTimeRangeChange({
      start: new Date(start).toISOString(),
      end: new Date(end).toISOString()
    });
  }, [onTimeRangeChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      minHeight: CHART_HEIGHT
    },
    direction: "column",
    justifyContent: "center",
    alignItems: isChartLoading === undefined ? 'center' : undefined
  }, !attributes ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    title: _translations.flyoutDegradedDocsTrendText,
    size: "l"
  }) : /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, {
    id: "datasetQualityFlyoutDegradedDocsTrend",
    css: lensEmbeddableComponentStyles,
    style: {
      height: CHART_HEIGHT
    },
    overrides: {
      settings: {
        legendAction: 'ignore'
      }
    },
    viewMode: _common.ViewMode.VIEW,
    hidePanelTitles: true,
    disabledActions: DISABLED_ACTIONS,
    timeRange: timeRange,
    attributes: attributes,
    withDefaultActions: true,
    extraActions: extraActions,
    disableTriggers: false,
    lastReloadRequestTime: lastReloadTime,
    onLoad: onChartLoading,
    onBrushEnd: handleBrushEnd
  }))));
}
const lensEmbeddableComponentStyles = (0, _react2.css)`
  .lnsExpressionRenderer__component {
    margin-left: -16px;

    .expExpressionRenderer__expression {
      padding: 0 !important;
    }
  }
`;