"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparkPlot = SparkPlot;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SparkPlot({
  valueLabel,
  isLoading,
  series
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(SparkPlotItem, {
    isLoading: isLoading,
    series: series
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, valueLabel));
}
function SparkPlotItem({
  isLoading,
  series
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartSize = {
    height: euiTheme.size.l,
    width: '80px'
  };
  const commonStyle = {
    ...chartSize,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  };
  const palette = (0, _eui.euiPaletteColorBlind)({
    rotations: 2
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: commonStyle
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null));
  }
  if (hasValidTimeSeries(series)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        backgroundColor: `${palette[0]}`,
        padding: 1,
        height: '100%'
      },
      "data-test-subj": "datasetQualitySparkPlot"
    }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
      size: chartSize
    }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
      showLegend: false,
      locale: _i18n.i18n.getLocale()
    }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
      type: "none"
    }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: "barseries",
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: "x",
      yAccessors: ['y'],
      data: series,
      color: palette[1]
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: commonStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "visLine",
    color: euiTheme.colors.mediumShade
  }));
}
function hasValidTimeSeries(series) {
  return !!(series !== null && series !== void 0 && series.some(point => point.y !== 0));
}