"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _file_manager = require("./file_manager/file_manager");
var _merge_tools = require("./file_manager/merge_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileStatus = ({
  fileStatus,
  uploadStatus,
  deleteFile,
  index
}) => {
  var _uploadStatus$fileCla;
  const fileClash = (_uploadStatus$fileCla = uploadStatus.fileClashes[index]) !== null && _uploadStatus$fileCla !== void 0 ? _uploadStatus$fileCla : {
    clash: false
  };
  const importStarted = uploadStatus.overallImportStatus === _file_manager.STATUS.STARTED || uploadStatus.overallImportStatus === _file_manager.STATUS.COMPLETED;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    color: fileClash.clash ? 'danger' : 'transparent'
  }, importStarted ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: Math.floor(fileStatus.importProgress),
    max: 100,
    size: "s",
    label: fileStatus.fileName,
    valueText: true,
    color: fileStatus.importProgress === 100 ? 'success' : 'primary'
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 8
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: {
      fontWeight: 'bold'
    }
  }, fileStatus.fileName), ' ', /*#__PURE__*/_react.default.createElement("span", null, fileStatus.fileSize))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: deleteFile,
    iconType: "trash",
    size: "xs",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.fileStatus.deleteFile', {
      defaultMessage: 'Remove file'
    })
  }))))), fileClash.clash ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fileClash.clashType === _merge_tools.CLASH_TYPE.FORMAT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.fileFormatClash",
    defaultMessage: "File format different from other files"
  }))) : null, fileClash.clashType === _merge_tools.CLASH_TYPE.MAPPING ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.mappingClash",
    defaultMessage: "Mappings incompatible with other files"
  }))) : null, fileClash.clashType === _merge_tools.CLASH_TYPE.UNSUPPORTED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.fileFormatNotSupported",
    defaultMessage: "File format not supported"
  }))) : null) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.FileStatus = FileStatus;