"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportSummary = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _failures = require("./failures");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ImportSummary = ({
  index,
  dataView,
  pipelineId,
  docCount,
  importFailures,
  createDataView,
  createPipeline
}) => {
  const items = createDisplayItems(index, dataView, pipelineId, docCount, importFailures, createDataView, createPipeline);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importSummary.importCompleteTitle",
      defaultMessage: "Import complete"
    }),
    color: "success",
    iconType: "check",
    "data-test-subj": "dataVisualizerFileImportSuccessCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    columnWidths: [15, 85],
    listItems: items,
    className: "import-summary-list"
  })), importFailures && importFailures.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importSummary.documentsCouldNotBeImportedTitle",
      defaultMessage: "Some documents could not be imported"
    }),
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.importSummary.documentsCouldNotBeImportedDescription",
    defaultMessage: "{importFailuresLength} out of {docCount} documents could not be imported. This could be due to lines not matching the Grok pattern.",
    values: {
      importFailuresLength: importFailures.length,
      docCount
    }
  })), /*#__PURE__*/_react.default.createElement(_failures.Failures, {
    failedDocs: importFailures
  }))));
};
exports.ImportSummary = ImportSummary;
function createDisplayItems(index, dataView, pipelineId, docCount, importFailures, createDataView, createPipeline) {
  const items = [{
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importSummary.indexTitle",
      defaultMessage: "Index"
    }),
    description: index
  }, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importSummary.documentsIngestedTitle",
      defaultMessage: "Documents ingested"
    }),
    description: docCount - (importFailures && importFailures.length || 0)
  }];
  if (createPipeline) {
    items.splice(1, 0, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importSummary.ingestPipelineTitle",
        defaultMessage: "Ingest pipeline"
      }),
      description: pipelineId
    });
  }
  if (createDataView) {
    items.splice(1, 0, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importSummary.dataViewTitle",
        defaultMessage: "Data view"
      }),
      description: dataView
    });
  }
  if (importFailures && importFailures.length > 0) {
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importSummary.failedDocumentsTitle",
        defaultMessage: "Failed documents"
      }),
      description: importFailures.length
    });
  }
  return items;
}